/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.TypeReader;
import org.apache.poi.util.LittleEndian;

public class Property {
    private static int CP_UNICODE = 1200;
    private int id;
    private long type;
    private Object value;

    public int getID() {
        return this.id;
    }

    public Object getValue() {
        return this.value;
    }

    public Property(int id, byte[] src, long offset, int length, int codepage) {
        this.id = id;
        if (id == 0) {
            this.value = this.readDictionary(src, offset, length, codepage);
            return;
        }
        int o = (int)offset;
        this.type = LittleEndian.getUInt(src, o);
        o += 4;
        try {
            this.value = TypeReader.read(src, o, length, (int)this.type);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.value = "*** null ***";
        }
    }

    protected Map readDictionary(byte[] src, long offset, int length, int codepage) {
        if (offset < 0L || offset > (long)src.length) {
            throw new HPSFRuntimeException("Illegal offset " + offset + " while HPSF stream contains " + length + " bytes.");
        }
        int o = (int)offset;
        long nrEntries = LittleEndian.getUInt(src, o);
        o += 4;
        HashMap<Long, String> m = new HashMap<Long, String>((int)nrEntries, 1.0f);
        int i = 0;
        while ((long)i < nrEntries) {
            Long id = new Long(LittleEndian.getUInt(src, o));
            long sLength = LittleEndian.getUInt(src, o += 4);
            o += 4;
            StringBuffer b = new StringBuffer((int)sLength);
            int j = 0;
            while ((long)j < sLength) {
                if (codepage == CP_UNICODE) {
                    int i1 = o + j * 2;
                    int i2 = i1 + 1;
                    b.append((char)((src[i2] << 8) + src[i1]));
                } else {
                    b.append((char)src[o + j]);
                }
                ++j;
            }
            while (b.charAt(b.length() - 1) == '\u0000') {
                b.setLength(b.length() - 1);
            }
            if (codepage == CP_UNICODE) {
                if (sLength % 2L == 1L) {
                    ++sLength;
                }
                o = (int)((long)o + (sLength + sLength));
            } else {
                o = (int)((long)o + sLength);
            }
            m.put(id, b.toString());
            ++i;
        }
        return m;
    }
}

