/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.planner.schema.impl.runtime;

import com.sun.xml.bind.JAXBAssertionError;
import com.sun.xml.bind.JAXBObject;
import com.sun.xml.bind.marshaller.IdentifiableObject;
import com.sun.xml.bind.marshaller.Messages;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.bind.serializer.AbortSerializationException;
import com.sun.xml.bind.serializer.Util;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.NotIdentifiableEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import net.sf.mpxj.planner.schema.impl.runtime.MarshallerImpl;
import net.sf.mpxj.planner.schema.impl.runtime.NamespaceContext2;
import net.sf.mpxj.planner.schema.impl.runtime.NamespaceContextImpl;
import net.sf.mpxj.planner.schema.impl.runtime.PrefixCallback;
import net.sf.mpxj.planner.schema.impl.runtime.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXMarshaller
implements XMLSerializer {
    private final AttributesImpl attributes = new AttributesImpl();
    private final ContentHandler writer;
    private final MarshallerImpl owner;
    private final Set idReferencedObjects = new HashSet();
    private final Set objectsWithId = new HashSet();
    private JAXBObject currentTarget;
    private final NamespaceContextImpl nsContext;
    private String[] elementStack = new String[16];
    private int elementLen = 0;
    private final PrefixCallback startPrefixCallback = new PrefixCallback(){

        public void onPrefixMapping(String prefix, String nsUri) throws SAXException {
            SAXMarshaller.this.writer.startPrefixMapping(prefix, nsUri);
        }
    };
    private final PrefixCallback endPrefixCallback = new PrefixCallback(){

        public void onPrefixMapping(String prefix, String nsUri) throws SAXException {
            SAXMarshaller.this.writer.endPrefixMapping(prefix);
        }
    };
    private final StringBuffer textBuf = new StringBuffer();
    private String attNamespaceUri;
    private String attLocalName;
    private static NamespacePrefixMapper defaultNamespacePrefixMapper = new NamespacePrefixMapper(){

        public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
            if (namespaceUri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                return "xsi";
            }
            return suggestion;
        }
    };

    public SAXMarshaller(ContentHandler _writer, NamespacePrefixMapper prefixMapper, MarshallerImpl _owner) {
        this.writer = _writer;
        this.owner = _owner;
        this.nsContext = new NamespaceContextImpl(prefixMapper != null ? prefixMapper : defaultNamespacePrefixMapper);
    }

    public NamespaceContext2 getNamespaceContext() {
        return this.nsContext;
    }

    private void pushElement(String uri, String local) {
        if (this.elementStack.length == this.elementLen) {
            String[] buf = new String[this.elementStack.length * 2];
            System.arraycopy(this.elementStack, 0, buf, 0, this.elementStack.length);
            this.elementStack = buf;
        }
        this.elementStack[this.elementLen++] = uri;
        this.elementStack[this.elementLen++] = local;
    }

    private void popElement() {
        this.elementLen -= 2;
    }

    private String getCurrentElementUri() {
        return this.elementStack[this.elementLen - 2];
    }

    private String getCurrentElementLocal() {
        return this.elementStack[this.elementLen - 1];
    }

    public void startElement(String uri, String local) throws SAXException {
        String[] uris;
        boolean isRoot = false;
        String suggestion = null;
        if (this.elementLen == 0) {
            isRoot = true;
            suggestion = "";
        }
        this.writePendingText();
        this.nsContext.startElement();
        this.pushElement(uri, local);
        this.nsContext.declareNamespace(uri, suggestion, false);
        if (isRoot && (uris = this.nsContext.getNamespacePrefixMapper().getPreDeclaredNamespaceUris()) != null) {
            int i = 0;
            while (i < uris.length) {
                if (uris[i] != null) {
                    this.nsContext.declareNamespace(uris[i], null, false);
                }
                ++i;
            }
        }
    }

    public void endNamespaceDecls() throws SAXException {
        this.nsContext.endNamespaceDecls();
    }

    public void endAttributes() throws SAXException {
        String uri = this.getCurrentElementUri();
        String local = this.getCurrentElementLocal();
        String prefix = this.nsContext.getPrefix(uri);
        SAXMarshaller._assert(prefix != null);
        String qname = prefix.length() != 0 ? String.valueOf(prefix) + ':' + local : local;
        this.nsContext.iterateDeclaredPrefixes(this.startPrefixCallback);
        this.writer.startElement(uri, local, qname, this.attributes);
        this.attributes.clear();
        this.textBuf.setLength(0);
    }

    public void endElement() throws SAXException {
        this.writePendingText();
        String uri = this.getCurrentElementUri();
        String local = this.getCurrentElementLocal();
        String prefix = this.nsContext.getPrefix(uri);
        SAXMarshaller._assert(prefix != null);
        String qname = prefix.length() != 0 ? String.valueOf(prefix) + ':' + local : local;
        this.writer.endElement(uri, local, qname);
        this.nsContext.iterateDeclaredPrefixes(this.endPrefixCallback);
        this.popElement();
        this.textBuf.setLength(0);
        this.nsContext.endElement();
    }

    public void text(String text, String fieldName) throws SAXException {
        if (text == null) {
            this.reportError(Util.createMissingObjectError(this.currentTarget, fieldName));
            return;
        }
        if (this.textBuf.length() != 0) {
            this.textBuf.append(' ');
        }
        this.textBuf.append(text);
    }

    private void writePendingText() throws SAXException {
        int len = this.textBuf.length();
        if (len != 0) {
            this.writer.characters(this.textBuf.toString().toCharArray(), 0, len);
        }
    }

    public void startAttribute(String uri, String local) {
        this.textBuf.setLength(0);
        this.attNamespaceUri = uri;
        this.attLocalName = local;
    }

    public void endAttribute() {
        String qname = this.attNamespaceUri.length() == 0 ? this.attLocalName : String.valueOf(this.nsContext.declareNamespace(this.attNamespaceUri, null, true)) + ':' + this.attLocalName;
        this.attributes.addAttribute(this.attNamespaceUri, this.attLocalName, qname, "CDATA", this.textBuf.toString());
    }

    public String onID(IdentifiableObject owner, String value) throws SAXException {
        this.objectsWithId.add(owner);
        return value;
    }

    public String onIDREF(IdentifiableObject obj) throws SAXException {
        this.idReferencedObjects.add(obj);
        String id = obj.____jaxb____getId();
        if (id == null) {
            this.reportError(new NotIdentifiableEventImpl(1, Messages.format("SAXMarshaller.NotIdentifiable"), new ValidationEventLocatorImpl(obj)));
        }
        return id;
    }

    void reconcileID() throws AbortSerializationException {
        this.idReferencedObjects.removeAll(this.objectsWithId);
        for (IdentifiableObject o : this.idReferencedObjects) {
            this.reportError(new NotIdentifiableEventImpl(1, Messages.format("SAXMarshaller.DanglingIDREF", o.____jaxb____getId()), new ValidationEventLocatorImpl(o)));
        }
        this.idReferencedObjects.clear();
        this.objectsWithId.clear();
    }

    public void childAsBody(JAXBObject o, String fieldName) throws SAXException {
        if (o == null) {
            this.reportMissingObjectError(fieldName);
            return;
        }
        JAXBObject oldTarget = this.currentTarget;
        this.currentTarget = o;
        this.owner.context.getGrammarInfo().castToXMLSerializable(o).serializeBody(this);
        this.currentTarget = oldTarget;
    }

    public void childAsAttributes(JAXBObject o, String fieldName) throws SAXException {
        if (o == null) {
            this.reportMissingObjectError(fieldName);
            return;
        }
        JAXBObject oldTarget = this.currentTarget;
        this.currentTarget = o;
        this.owner.context.getGrammarInfo().castToXMLSerializable(o).serializeAttributes(this);
        this.currentTarget = oldTarget;
    }

    public void childAsURIs(JAXBObject o, String fieldName) throws SAXException {
        if (o == null) {
            this.reportMissingObjectError(fieldName);
            return;
        }
        JAXBObject oldTarget = this.currentTarget;
        this.currentTarget = o;
        this.owner.context.getGrammarInfo().castToXMLSerializable(o).serializeURIs(this);
        this.currentTarget = oldTarget;
    }

    public void reportError(ValidationEvent ve) throws AbortSerializationException {
        ValidationEventHandler handler;
        try {
            handler = this.owner.getEventHandler();
        }
        catch (JAXBException e) {
            throw new AbortSerializationException(e);
        }
        if (!handler.handleEvent(ve)) {
            if (ve.getLinkedException() instanceof Exception) {
                throw new AbortSerializationException((Exception)ve.getLinkedException());
            }
            throw new AbortSerializationException(ve.getMessage());
        }
    }

    public void reportMissingObjectError(String fieldName) throws SAXException {
        this.reportError(Util.createMissingObjectError(this.currentTarget, fieldName));
    }

    private static void _assert(boolean b) {
        if (!b) {
            throw new JAXBAssertionError();
        }
    }
}

