/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.mpd.MapRow;
import net.sf.mpxj.utility.NumberUtility;

final class ResultSetRow
extends MapRow {
    public ResultSetRow(ResultSet rs, Map meta) throws SQLException {
        super(new HashMap());
        for (Map.Entry entry : meta.entrySet()) {
            Object value;
            String name = (String)entry.getKey();
            int type = (Integer)entry.getValue();
            switch (type) {
                case -7: 
                case 16: {
                    value = rs.getBoolean(name);
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    value = rs.getString(name);
                    break;
                }
                case 91: {
                    value = rs.getDate(name);
                    break;
                }
                case 93: {
                    Timestamp ts = rs.getTimestamp(name);
                    if (ts != null) {
                        value = new Date(ts.getTime());
                        break;
                    }
                    value = null;
                    break;
                }
                case 2: 
                case 8: {
                    value = NumberUtility.getDouble(rs.getDouble(name));
                    break;
                }
                case 4: 
                case 5: {
                    value = new Integer(rs.getInt(name));
                    break;
                }
                case -4: {
                    value = rs.getBytes(name);
                    break;
                }
                case 1111: {
                    value = rs.getObject(name);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + type + " for column " + name);
                }
            }
            if (rs.wasNull()) {
                value = null;
            }
            this.m_map.put(name, value);
        }
    }
}

