/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.mpd.MPDUtility;
import net.sf.mpxj.mpd.Row;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Pair;
import net.sf.mpxj.utility.RTFUtility;

abstract class MPD9AbstractReader {
    protected Integer m_projectID;
    private boolean m_preserveNoteFormatting;
    protected ProjectFile m_project;
    private Map m_calendarMap = new HashMap();
    private List m_baseCalendars = new LinkedList();
    private Map m_resourceMap = new HashMap();
    private RTFUtility m_rtf = new RTFUtility();
    private boolean m_autoWBS = true;
    private static final Set COST_FIELDS = new HashSet();

    static {
        COST_FIELDS.add(TaskField.COST1);
        COST_FIELDS.add(TaskField.COST2);
        COST_FIELDS.add(TaskField.COST3);
        COST_FIELDS.add(TaskField.COST4);
        COST_FIELDS.add(TaskField.COST5);
        COST_FIELDS.add(TaskField.COST6);
        COST_FIELDS.add(TaskField.COST7);
        COST_FIELDS.add(TaskField.COST8);
        COST_FIELDS.add(TaskField.COST9);
        COST_FIELDS.add(TaskField.COST10);
        COST_FIELDS.add(ResourceField.COST1);
        COST_FIELDS.add(ResourceField.COST2);
        COST_FIELDS.add(ResourceField.COST3);
        COST_FIELDS.add(ResourceField.COST4);
        COST_FIELDS.add(ResourceField.COST5);
        COST_FIELDS.add(ResourceField.COST6);
        COST_FIELDS.add(ResourceField.COST7);
        COST_FIELDS.add(ResourceField.COST8);
        COST_FIELDS.add(ResourceField.COST9);
        COST_FIELDS.add(ResourceField.COST10);
    }

    MPD9AbstractReader() {
    }

    protected void processProjectHeader(Row row) {
        ProjectHeader header = this.m_project.getProjectHeader();
        header.setCurrencySymbol(row.getString("PROJ_OPT_CURRENCY_SYMBOL"));
        header.setSymbolPosition(MPDUtility.getSymbolPosition(row.getInt("PROJ_OPT_CURRENCY_POSITION")));
        header.setCurrencyDigits(row.getInteger("PROJ_OPT_CURRENCY_DIGITS"));
        header.setDefaultDurationUnits(MPDUtility.getDurationTimeUnits(row.getInt("PROJ_OPT_DUR_ENTRY_FMT")));
        header.setDefaultWorkUnits(MPDUtility.getDurationTimeUnits(row.getInt("PROJ_OPT_WORK_ENTRY_FMT")));
        header.setMinutesPerDay(row.getInteger("PROJ_OPT_MINUTES_PER_DAY"));
        header.setMinutesPerWeek(row.getInteger("PROJ_OPT_MINUTES_PER_WEEK"));
        header.setDefaultStandardRate(new Rate(row.getDouble("PROJ_OPT_DEF_STD_RATE"), TimeUnit.HOURS));
        header.setDefaultOvertimeRate(new Rate(row.getDouble("PROJ_OPT_DEF_OVT_RATE"), TimeUnit.HOURS));
        header.setUpdatingTaskStatusUpdatesResourceStatus(row.getBoolean("PROJ_OPT_TASK_UPDATES_RES"));
        header.setSplitInProgressTasks(row.getBoolean("PROJ_OPT_SPLIT_IN_PROGRESS"));
        header.setDefaultStartTime(row.getDate("PROJ_OPT_DEF_START_TIME"));
        header.setProjectTitle(row.getString("PROJ_PROP_TITLE"));
        header.setCompany(row.getString("PROJ_PROP_COMPANY"));
        header.setManager(row.getString("PROJ_PROP_MANAGER"));
        header.setCalendarName(row.getString("PROJ_INFO_CAL_NAME"));
        header.setStartDate(row.getDate("PROJ_INFO_START_DATE"));
        header.setFinishDate(row.getDate("PROJ_INFO_FINISH_DATE"));
        header.setScheduleFrom(ScheduleFrom.getInstance(1 - row.getInt("PROJ_INFO_SCHED_FROM")));
        header.setCurrentDate(row.getDate("PROJ_INFO_CURRENT_DATE"));
        header.setSubject(row.getString("PROJ_PROP_SUBJECT"));
        header.setAuthor(row.getString("PROJ_PROP_AUTHOR"));
        header.setKeywords(row.getString("PROJ_PROP_KEYWORDS"));
        header.setDefaultEndTime(row.getDate("PROJ_OPT_DEF_FINISH_TIME"));
        header.setProjectExternallyEdited(row.getBoolean("PROJ_EXT_EDITED_FLAG"));
        header.setCategory(row.getString("PROJ_PROP_CATEGORY"));
        header.setDaysPerMonth(row.getInteger("PROJ_OPT_DAYS_PER_MONTH"));
        header.setFiscalYearStart(row.getBoolean("PROJ_OPT_FY_USE_START_YR"));
        header.setNewTasksEstimated(row.getBoolean("PROJ_OPT_NEW_TASK_EST"));
        header.setSpreadActualCost(row.getBoolean("PROJ_OPT_SPREAD_ACT_COSTS"));
        header.setMultipleCriticalPaths(row.getBoolean("PROJ_OPT_MULT_CRITICAL_PATHS"));
        header.setLastSaved(row.getDate("PROJ_LAST_SAVED"));
        header.setStatusDate(row.getDate("PROJ_INFO_STATUS_DATE"));
        header.setHonorConstraints(row.getBoolean("PROJ_OPT_HONOR_CONSTRAINTS"));
        header.setName(row.getString("PROJ_NAME"));
        header.setSpreadPercentComplete(row.getBoolean("PROJ_OPT_SPREAD_PCT_COMP"));
        header.setNewTasksEffortDriven(row.getBoolean("PROJ_OPT_NEW_ARE_EFFORT_DRIVEN"));
        header.setDefaultTaskType(TaskType.getInstance(row.getInt("PROJ_OPT_DEF_TASK_TYPE")));
        header.setCreationDate(row.getDate("PROJ_CREATION_DATE"));
        header.setDefaultFixedCostAccrual(AccrueType.getInstance(row.getInt("PROJ_OPT_DEF_FIX_COST_ACCRUAL")));
        header.setCriticalSlackLimit(row.getInteger("PROJ_OPT_CRITICAL_SLACK_LIMIT"));
        header.setFiscalYearStartMonth(row.getInteger("PROJ_OPT_FY_START_MONTH"));
        header.setWeekStartDay(Day.getInstance(row.getInt("PROJ_OPT_WEEK_START_DAY") + 1));
        header.setMultipleCriticalPaths(row.getBoolean("PROJ_OPT_MULT_CRITICAL_PATHS"));
    }

    protected void processCalendar(Row row) {
        Integer uniqueID = row.getInteger("CAL_UID");
        if (NumberUtility.getInt(uniqueID) > 0) {
            boolean baseCalendar = row.getBoolean("CAL_IS_BASE_CAL");
            ProjectCalendar cal = null;
            if (baseCalendar) {
                cal = this.m_project.addBaseCalendar();
                cal.setName(row.getString("CAL_NAME"));
            } else {
                Integer resourceID = row.getInteger("RES_UID");
                if (resourceID != null && resourceID != 0) {
                    cal = this.m_project.addResourceCalendar();
                    this.m_baseCalendars.add(new Pair(cal, row.getInteger("CAL_BASE_UID")));
                    this.m_resourceMap.put(resourceID, cal);
                }
            }
            if (cal != null) {
                cal.setUniqueID(uniqueID);
                this.m_calendarMap.put(uniqueID, cal);
            }
        }
    }

    protected void processCalendarData(ProjectCalendar calendar, Row row) {
        int dayIndex = row.getInt("CD_DAY_OR_EXCEPTION");
        if (dayIndex == 0) {
            this.processCalendarException(calendar, row);
        } else {
            this.processCalendarHours(calendar, row, dayIndex);
        }
    }

    private void processCalendarException(ProjectCalendar calendar, Row row) {
        ProjectCalendarException exception = calendar.addCalendarException();
        exception.setWorking(row.getInt("CD_WORKING") != 0);
        exception.setFromDate(row.getDate("CD_FROM_DATE"));
        exception.setFromTime1(row.getDate("CD_FROM_TIME1"));
        exception.setFromTime2(row.getDate("CD_FROM_TIME2"));
        exception.setFromTime3(row.getDate("CD_FROM_TIME3"));
        exception.setFromTime4(row.getDate("CD_FROM_TIME4"));
        exception.setFromTime5(row.getDate("CD_FROM_TIME5"));
        exception.setToDate(row.getDate("CD_TO_DATE"));
        exception.setToTime1(row.getDate("CD_TO_TIME1"));
        exception.setToTime2(row.getDate("CD_TO_TIME2"));
        exception.setToTime3(row.getDate("CD_TO_TIME3"));
        exception.setToTime4(row.getDate("CD_TO_TIME4"));
        exception.setToTime5(row.getDate("CD_TO_TIME5"));
    }

    private void processCalendarHours(ProjectCalendar calendar, Row row, int dayIndex) {
        Day day = Day.getInstance(dayIndex);
        boolean working = row.getInt("CD_WORKING") != 0;
        calendar.setWorkingDay(day, working);
        if (working) {
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            Date start = row.getDate("CD_FROM_TIME1");
            Date end = row.getDate("CD_TO_TIME1");
            if (start != null && end != null) {
                hours.addDateRange(new DateRange(start, end));
            }
            start = row.getDate("CD_FROM_TIME2");
            end = row.getDate("CD_TO_TIME2");
            if (start != null && end != null) {
                hours.addDateRange(new DateRange(start, end));
            }
            start = row.getDate("CD_FROM_TIME3");
            end = row.getDate("CD_TO_TIME3");
            if (start != null && end != null) {
                hours.addDateRange(new DateRange(start, end));
            }
            start = row.getDate("CD_FROM_TIME4");
            end = row.getDate("CD_TO_TIME4");
            if (start != null && end != null) {
                hours.addDateRange(new DateRange(start, end));
            }
            start = row.getDate("CD_FROM_TIME5");
            end = row.getDate("CD_TO_TIME5");
            if (start != null && end != null) {
                hours.addDateRange(new DateRange(start, end));
            }
        }
    }

    protected void updateBaseCalendarNames() {
        for (Pair pair : this.m_baseCalendars) {
            ProjectCalendar cal = (ProjectCalendar)pair.getFirst();
            Integer baseCalendarID = (Integer)pair.getSecond();
            ProjectCalendar baseCal = (ProjectCalendar)this.m_calendarMap.get(baseCalendarID);
            if (baseCal == null) continue;
            cal.setBaseCalendar(baseCal);
        }
    }

    protected void processResource(Row row) {
        Integer uniqueID = row.getInteger("RES_UID");
        if (uniqueID != null && uniqueID >= 0) {
            Resource resource = this.m_project.addResource();
            resource.setAccrueAt(AccrueType.getInstance(row.getInt("RES_ACCRUE_AT")));
            resource.setActualCost(this.getDefaultOnNull(row.getCurrency("RES_ACT_COST"), NumberUtility.DOUBLE_ZERO));
            resource.setActualOvertimeCost(row.getCurrency("RES_ACT_OVT_COST"));
            resource.setActualOvertimeWork(row.getDuration("RES_ACT_OVT_WORK"));
            resource.setActualWork(row.getDuration("RES_ACT_WORK"));
            resource.setACWP(row.getCurrency("RES_ACWP"));
            resource.setAvailableFrom(row.getDate("RES_AVAIL_FROM"));
            resource.setAvailableTo(row.getDate("RES_AVAIL_TO"));
            resource.setBaselineCost(this.getDefaultOnNull(row.getCurrency("RES_BASE_COST"), NumberUtility.DOUBLE_ZERO));
            resource.setBaselineWork(row.getDuration("RES_BASE_WORK"));
            resource.setBCWP(row.getCurrency("RES_BCWP"));
            resource.setBCWS(row.getCurrency("RES_BCWS"));
            resource.setCanLevel(row.getBoolean("RES_CAN_LEVEL"));
            resource.setCost(this.getDefaultOnNull(row.getCurrency("RES_COST"), NumberUtility.DOUBLE_ZERO));
            resource.setCostPerUse(row.getCurrency("RES_COST_PER_USE"));
            resource.setID(row.getInteger("RES_ID"));
            resource.setInitials(row.getString("RES_INITIALS"));
            resource.setMaterialLabel(row.getString("RES_MATERIAL_LABEL"));
            resource.setMaxUnits(new Double(NumberUtility.getDouble(row.getDouble("RES_MAX_UNITS")) * 100.0));
            resource.setName(row.getString("RES_NAME"));
            resource.setObjects(this.getNullOnValue(row.getInteger("RES_NUM_OBJECTS"), 0));
            resource.setOverAllocated(row.getBoolean("RES_IS_OVERALLOCATED"));
            resource.setOvertimeCost(row.getCurrency("RES_OVT_COST"));
            resource.setOvertimeRate(new Rate(row.getDouble("RES_OVT_RATE"), TimeUnit.HOURS));
            resource.setOvertimeRateFormat(TimeUnit.getInstance(row.getInt("RES_OVT_RATE_FMT") - 1));
            resource.setOvertimeWork(row.getDuration("RES_OVT_WORK"));
            resource.setPeakUnits(new Double(NumberUtility.getDouble(row.getDouble("RES_PEAK")) * 100.0));
            resource.setPhonetics(row.getString("RES_PHONETICS"));
            resource.setRegularWork(row.getDuration("RES_REG_WORK"));
            resource.setRemainingCost(this.getDefaultOnNull(row.getCurrency("RES_REM_COST"), NumberUtility.DOUBLE_ZERO));
            resource.setRemainingOvertimeCost(row.getCurrency("RES_REM_OVT_COST"));
            resource.setRemainingOvertimeWork(row.getDuration("RES_REM_OVT_WORK"));
            resource.setRemainingWork(row.getDuration("RES_REM_WORK"));
            resource.setStandardRate(new Rate(row.getDouble("RES_STD_RATE"), TimeUnit.HOURS));
            resource.setStandardRateFormat(TimeUnit.getInstance(row.getInt("RES_STD_RATE_FMT") - 1));
            resource.setType(row.getBoolean("RES_TYPE") ? ResourceType.WORK : ResourceType.MATERIAL);
            resource.setUniqueID(uniqueID);
            resource.setWork(row.getDuration("RES_WORK"));
            resource.setWorkGroup(WorkGroup.getInstance(row.getInt("RES_WORKGROUP_MESSAGING")));
            String notes = row.getString("RES_RTF_NOTES");
            if (notes != null) {
                if (!this.m_preserveNoteFormatting) {
                    notes = this.m_rtf.strip(notes);
                }
                resource.setNotes(notes);
            }
            resource.setResourceCalendar(this.m_project.getBaseCalendarByUniqueID(row.getInteger("RES_CAL_UID")));
            if (resource.getCost() != null && resource.getBaselineCost() != null) {
                resource.setCostVariance(NumberUtility.getDouble(resource.getCost().doubleValue() - resource.getBaselineCost().doubleValue()));
            }
            if (resource.getWork() != null && resource.getBaselineWork() != null) {
                resource.setWorkVariance(Duration.getInstance(resource.getWork().getDuration() - resource.getBaselineWork().getDuration(), TimeUnit.HOURS));
            }
            resource.setOverAllocated(NumberUtility.getDouble(resource.getPeakUnits()) > NumberUtility.getDouble(resource.getMaxUnits()));
            this.m_project.fireResourceReadEvent(resource);
        }
    }

    protected void processTextField(Row row) {
        this.processField(row, "TEXT_FIELD_ID", "TEXT_REF_UID", (Object)row.getString("TEXT_VALUE"));
    }

    protected void processNumberField(Row row) {
        this.processField(row, "NUM_FIELD_ID", "NUM_REF_UID", (Object)row.getDouble("NUM_VALUE"));
    }

    protected void processFlagField(Row row) {
        this.processField(row, "FLAG_FIELD_ID", "FLAG_REF_UID", (Object)row.getBoolean("FLAG_VALUE"));
    }

    protected void processDurationField(Row row) {
        this.processField(row, "DUR_FIELD_ID", "DUR_REF_UID", (Object)MPDUtility.getAdjustedDuration(this.m_project, row.getInt("DUR_VALUE"), MPDUtility.getDurationTimeUnits(row.getInt("DUR_FMT"))));
    }

    protected void processDateField(Row row) {
        this.processField(row, "DATE_FIELD_ID", "DATE_REF_UID", (Object)row.getDate("DATE_VALUE"));
    }

    protected void processOutlineCodeField(Integer entityID, Row row) {
        this.processField(row, "OC_FIELD_ID", entityID, (Object)row.getString("OC_NAME"));
    }

    protected void processField(Row row, String fieldIDColumn, String entityIDColumn, Object value) {
        this.processField(row, fieldIDColumn, row.getInteger(entityIDColumn), value);
    }

    protected void processField(Row row, String fieldIDColumn, Integer entityID, Object value) {
        int fieldID = row.getInt(fieldIDColumn);
        int prefix = fieldID & 0xFFFF0000;
        int index = fieldID & 0xFFFF;
        if (prefix == 0xB400000) {
            Task task;
            TaskField field = MPPTaskField.getInstance(index);
            if (field != null && field != TaskField.NOTES && (task = this.m_project.getTaskByUniqueID(entityID)) != null) {
                if (COST_FIELDS.contains(field)) {
                    value = new Double((Double)value / 100.0);
                }
                task.set((FieldType)field, value);
            }
        } else {
            Resource resource;
            ResourceField field = MPPResourceField.getInstance(index);
            if (field != null && field != ResourceField.NOTES && (resource = this.m_project.getResourceByUniqueID(entityID)) != null) {
                if (COST_FIELDS.contains(field)) {
                    value = new Double((Double)value / 100.0);
                }
                resource.set((FieldType)field, value);
            }
        }
    }

    protected void processTask(Row row) {
        Integer uniqueID = row.getInteger("TASK_UID");
        if (uniqueID != null && uniqueID >= 0) {
            Task task = this.m_project.addTask();
            TimeUnit durationFormat = MPDUtility.getDurationTimeUnits(row.getInt("TASK_DUR_FMT"));
            task.setActualCost(row.getCurrency("TASK_ACT_COST"));
            task.setActualDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_ACT_DUR"), durationFormat));
            task.setActualFinish(row.getDate("TASK_ACT_FINISH"));
            task.setActualOvertimeCost(row.getCurrency("TASK_ACT_OVT_COST"));
            task.setActualOvertimeWork(row.getDuration("TASK_ACT_OVT_WORK"));
            task.setActualStart(row.getDate("TASK_ACT_START"));
            task.setActualWork(row.getDuration("TASK_ACT_WORK"));
            task.setACWP(row.getCurrency("TASK_ACWP"));
            task.setBaselineCost(row.getCurrency("TASK_BASE_COST"));
            task.setBaselineDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_BASE_DUR"), durationFormat));
            task.setBaselineFinish(row.getDate("TASK_BASE_FINISH"));
            task.setBaselineStart(row.getDate("TASK_BASE_START"));
            task.setBaselineWork(row.getDuration("TASK_BASE_WORK"));
            task.setCalendar(this.m_project.getBaseCalendarByUniqueID(row.getInteger("TASK_CAL_UID")));
            task.setConstraintDate(row.getDate("TASK_CONSTRAINT_DATE"));
            task.setConstraintType(ConstraintType.getInstance(row.getInt("TASK_CONSTRAINT_TYPE")));
            task.setCost(row.getCurrency("TASK_COST"));
            task.setCreateDate(row.getDate("TASK_CREATION_DATE"));
            task.setDeadline(row.getDate("TASK_DEADLINE"));
            task.setDurationFormat(durationFormat);
            task.setDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_DUR"), durationFormat));
            task.setDurationVariance(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_DUR_VAR"), durationFormat));
            task.setEarlyFinish(row.getDate("TASK_EARLY_FINISH"));
            task.setEarlyStart(row.getDate("TASK_EARLY_START"));
            task.setEffortDriven(row.getBoolean("TASK_IS_EFFORT_DRIVEN"));
            task.setEstimated(row.getBoolean("TASK_DUR_IS_EST"));
            task.setExpanded(!row.getBoolean("TASK_IS_COLLAPSED"));
            task.setExternalTask(row.getBoolean("TASK_IS_EXTERNAL"));
            task.setFinish(row.getDate("TASK_FINISH_DATE"));
            task.setFixedCost(row.getCurrency("TASK_FIXED_COST"));
            task.setFixedCostAccrual(AccrueType.getInstance(row.getInt("TASK_FIXED_COST_ACCRUAL")));
            task.setFreeSlack(row.getDuration("TASK_FREE_SLACK").convertUnits(task.getDurationFormat(), this.m_project.getProjectHeader()));
            task.setHideBar(row.getBoolean("TASK_BAR_IS_HIDDEN"));
            task.setID(row.getInteger("TASK_ID"));
            task.setIgnoreResourceCalendar(row.getBoolean("TASK_IGNORES_RES_CAL"));
            task.setLateFinish(row.getDate("TASK_LATE_FINISH"));
            task.setLateStart(row.getDate("TASK_LATE_START"));
            task.setLevelAssignments(row.getBoolean("TASK_LEVELING_ADJUSTS_ASSN"));
            task.setLevelingCanSplit(row.getBoolean("TASK_LEVELING_CAN_SPLIT"));
            task.setLevelingDelayFormat(MPDUtility.getDurationTimeUnits(row.getInt("TASK_LEVELING_DELAY_FMT")));
            task.setLevelingDelay(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_LEVELING_DELAY"), task.getLevelingDelayFormat()));
            task.setMarked(row.getBoolean("TASK_IS_MARKED"));
            task.setMilestone(row.getBoolean("TASK_IS_MILESTONE"));
            task.setName(row.getString("TASK_NAME"));
            task.setObjects(this.getNullOnValue(row.getInteger("TASK_NUM_OBJECTS"), 0));
            task.setOutlineLevel(row.getInteger("TASK_OUTLINE_LEVEL"));
            task.setOutlineNumber(row.getString("TASK_OUTLINE_NUM"));
            task.setOverAllocated(row.getBoolean("TASK_IS_OVERALLOCATED"));
            task.setOvertimeCost(row.getCurrency("TASK_OVT_COST"));
            task.setPercentageComplete(row.getDouble("TASK_PCT_COMP"));
            task.setPercentageWorkComplete(row.getDouble("TASK_PCT_WORK_COMP"));
            task.setPreleveledFinish(row.getDate("TASK_PRELEVELED_FINISH"));
            task.setPreleveledStart(row.getDate("TASK_PRELEVELED_START"));
            task.setPriority(Priority.getInstance(row.getInt("TASK_PRIORITY")));
            task.setRecurring(row.getBoolean("TASK_IS_RECURRING"));
            task.setRegularWork(row.getDuration("TASK_REG_WORK"));
            task.setRemainingCost(row.getCurrency("TASK_REM_COST"));
            task.setRemainingDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_REM_DUR"), durationFormat));
            task.setRemainingOvertimeCost(row.getCurrency("TASK_REM_OVT_COST"));
            task.setRemainingOvertimeWork(row.getDuration("TASK_REM_OVT_WORK"));
            task.setRemainingWork(row.getDuration("TASK_REM_WORK"));
            task.setResume(row.getDate("TASK_RESUME_DATE"));
            task.setRollup(row.getBoolean("TASK_IS_ROLLED_UP"));
            task.setStart(row.getDate("TASK_START_DATE"));
            task.setStop(row.getDate("TASK_STOP_DATE"));
            task.setSummary(row.getBoolean("TASK_IS_SUMMARY"));
            task.setType(TaskType.getInstance(row.getInt("TASK_TYPE")));
            task.setUniqueID(uniqueID);
            task.setWBS(row.getString("TASK_WBS"));
            task.setWork(row.getDuration("TASK_WORK"));
            String notes = row.getString("TASK_RTF_NOTES");
            if (notes != null) {
                if (!this.m_preserveNoteFormatting) {
                    notes = this.m_rtf.strip(notes);
                }
                task.setNotes(notes);
            }
            if (task.getCost() != null && task.getBaselineCost() != null) {
                task.setCostVariance(NumberUtility.getDouble(task.getCost().doubleValue() - task.getBaselineCost().doubleValue()));
            }
            task.setFlag1(false);
            task.setFlag2(false);
            task.setFlag3(false);
            task.setFlag4(false);
            task.setFlag5(false);
            task.setFlag6(false);
            task.setFlag7(false);
            task.setFlag8(false);
            task.setFlag9(false);
            task.setFlag10(false);
            if (task.getWBS() != null) {
                this.m_autoWBS = false;
            }
        }
    }

    protected void processLink(Row row) {
        Task predecessorTask = this.m_project.getTaskByUniqueID(row.getInteger("LINK_PRED_UID"));
        Task successorTask = this.m_project.getTaskByUniqueID(row.getInteger("LINK_SUCC_UID"));
        if (predecessorTask != null && successorTask != null) {
            RelationType type = RelationType.getInstance(row.getInt("LINK_TYPE"));
            TimeUnit durationUnits = MPDUtility.getDurationTimeUnits(row.getInt("LINK_LAG_FMT"));
            Duration duration = MPDUtility.getDuration(row.getDouble("LINK_LAG"), durationUnits);
            Relation rel = successorTask.addPredecessor(predecessorTask);
            rel.setType(type);
            rel.setDuration(duration);
        }
    }

    protected void processAssignment(Row row) {
        Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("RES_UID"));
        Task task = this.m_project.getTaskByUniqueID(row.getInteger("TASK_UID"));
        if (task != null && resource != null) {
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setActualCost(row.getCurrency("ASSN_ACT_COST"));
            assignment.setActualWork(row.getDuration("ASSN_ACT_WORK"));
            assignment.setCost(row.getCurrency("ASSN_COST"));
            assignment.setDelay(row.getDuration("ASSN_DELAY"));
            assignment.setFinish(row.getDate("ASSN_FINISH_DATE"));
            assignment.setOvertimeWork(row.getDuration("ASSN_OVT_WORK"));
            assignment.setRemainingWork(row.getDuration("ASSN_REM_WORK"));
            assignment.setStart(row.getDate("ASSN_START_DATE"));
            assignment.setUnits(new Double(row.getDouble("ASSN_UNITS") * 100.0));
            assignment.setWork(row.getDuration("ASSN_WORK"));
            assignment.setWorkContour(WorkContour.getInstance(row.getInt("ASSN_WORK_CONTOUR")));
        }
    }

    protected void postProcessing() {
        this.m_project.setAutoWBS(this.m_autoWBS);
        this.m_project.setAutoOutlineNumber(true);
        this.m_project.updateStructure();
        this.m_project.setAutoOutlineNumber(false);
        List tasks = this.m_project.getAllTasks();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            Task task;
            task.setSummary((task = (Task)iter.next()).getChildTasks().size() != 0);
        }
        this.m_project.updateUniqueCounters();
    }

    private Integer getNullOnValue(Integer value, int nullValue) {
        return NumberUtility.getInt(value) == nullValue ? null : value;
    }

    public Double getDefaultOnNull(Double value, Double defaultValue) {
        return value == null ? defaultValue : value;
    }

    public Integer getDefaultOnNull(Integer value, Integer defaultValue) {
        return value == null ? defaultValue : value;
    }

    public void setProjectID(Integer projectID) {
        this.m_projectID = projectID;
    }

    public void setPreserveNoteFormatting(boolean preserveNoteFormatting) {
        this.m_preserveNoteFormatting = preserveNoteFormatting;
    }
}

