/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.util.HashSet;
import java.util.List;
import net.sf.mpxj.Column;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.View;
import net.sf.mpxj.ViewType;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.GanttChartView;
import net.sf.mpxj.mpp.MPPReader;

public class MppViewTest
extends MPXJTestCase {
    public void testMpp9View() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp9resource.mpp");
        this.testViews(mpp);
    }

    public void testMpp12View() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp12resource.mpp");
        this.testViews(mpp);
    }

    private void testViews(ProjectFile mpp) {
        List views = mpp.getViews();
        HashSet<String> setViewNames = new HashSet<String>();
        int viewNum = 0;
        while (viewNum < views.size()) {
            GanttChartView view9;
            View view = (View)views.get(viewNum);
            String viewName = view.getName();
            setViewNames.add(viewName);
            Table table = null;
            if (view instanceof GanttChartView && (view9 = (GanttChartView)view).getTable() != null) {
                table = view9.getTable();
                ViewType viewType = view.getType();
                MppViewTest.assertEquals((Object)ViewType.GANTT_CHART, (Object)viewType);
                List cols = table.getColumns();
                HashSet<String> setColumnNames = new HashSet<String>();
                int n = 0;
                while (n < cols.size()) {
                    Column col = (Column)cols.get(n);
                    setColumnNames.add(col.getTitle());
                    int width = col.getWidth();
                    MppViewTest.assertTrue((width > 0 ? 1 : 0) != 0);
                    ++n;
                }
                MppViewTest.assertEquals((int)7, (int)setColumnNames.size());
                MppViewTest.assertTrue((boolean)setColumnNames.contains("ID"));
                MppViewTest.assertTrue((boolean)setColumnNames.contains("Unique ID"));
                MppViewTest.assertTrue((boolean)setColumnNames.contains("Task Name"));
                MppViewTest.assertTrue((boolean)setColumnNames.contains("Indicators"));
                MppViewTest.assertTrue((boolean)setColumnNames.contains("Start"));
                MppViewTest.assertTrue((boolean)setColumnNames.contains("Finish"));
                MppViewTest.assertTrue((boolean)setColumnNames.contains("Resource Names"));
                MppViewTest.assertTrue((view9.getTableWidth() > 0 ? 1 : 0) != 0);
            }
            ++viewNum;
        }
        MppViewTest.assertTrue((boolean)setViewNames.contains("Gantt Chart"));
        MppViewTest.assertTrue((boolean)setViewNames.contains("Test View"));
        MppViewTest.assertTrue((boolean)setViewNames.contains("Tracking Gantt"));
        MppViewTest.assertTrue((boolean)setViewNames.contains("Resource Sheet"));
        MppViewTest.assertTrue((boolean)setViewNames.contains("Resource Usage"));
        MppViewTest.assertTrue((boolean)setViewNames.contains("Task Usage"));
    }
}

