/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data;

import com.projity.company.ApplicationUser;
import com.projity.configuration.Configuration;
import com.projity.datatype.ImageLink;
import com.projity.field.DelegatesFields;
import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.pm.costing.EarnedValueCalculator;
import com.projity.pm.costing.EarnedValueIndicatorFields;
import com.projity.pm.key.HasName;
import com.projity.server.data.CalendarData;
import com.projity.server.data.DocumentData;
import com.projity.server.data.SerializedDataObject;
import com.projity.server.data.SerializedDataObjectFactory;
import com.projity.session.SessionFactory;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class ProjectData
extends DocumentData
implements HasName,
DelegatesFields,
EarnedValueIndicatorFields,
Comparable {
    static final long serialVersionUID = 722537477839L;
    public static final long GANTT = 1L;
    public static final long NETWORK = 16L;
    public static final long SVG = 32L;
    public static final long PNG = 64L;
    public static final long PDF = 128L;
    public static final long GANTT_SVG = 33L;
    public static final long GANTT_PDF = 129L;
    public static final long GANTT_PNG = 65L;
    public static final long NETWORK_SVG = 48L;
    public static final long NETWORK_PDF = 144L;
    public static final long NETWORK_PNG = 80L;
    protected CalendarData calendar;
    protected Collection resources;
    protected Collection tasks;
    protected long calendarId = -1L;
    protected long lockedById;
    protected String lockedByName;
    protected long idleTime;
    protected long allowedIdleTime;
    protected Date creationDate;
    protected Date lastModificationDate;
    protected Collection distributions;
    protected Map fieldValues;
    protected Map extraFields;
    protected Collection referringSubprojectTasks;
    protected long availableImages = 113L;
    protected String group;
    protected String division;
    protected int expenseType;
    protected int projectType;
    protected int projectStatus;
    protected int accessControlPolicy;
    protected float version = 1.2f;
    protected long[] unchangedTasks;
    protected long[] unchangedLinks;
    protected boolean incrementalDistributions;
    public static final SerializedDataObjectFactory FACTORY = new SerializedDataObjectFactory(){

        public SerializedDataObject createSerializedDataObject() {
            return new ProjectData();
        }
    };
    private static Field ganttSnapshotFieldInstance = null;
    private static Field networkSnapshotFieldInstance = null;

    public CalendarData getCalendar() {
        return this.calendar;
    }

    public void setCalendar(CalendarData calendarData) {
        this.calendar = calendarData;
        this.setCalendarId(calendarData == null ? -1L : calendarData.getUniqueId());
    }

    public Collection getResources() {
        return this.resources;
    }

    public void setResources(Collection collection) {
        this.resources = collection;
    }

    public Collection getTasks() {
        return this.tasks;
    }

    public void setTasks(Collection collection) {
        this.tasks = collection;
    }

    public int getType() {
        return 2;
    }

    public long getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(long l) {
        this.calendarId = l;
    }

    public String getLockedByName() {
        return this.lockedByName;
    }

    public void setLockedByName(String string) {
        this.lockedByName = string;
    }

    public long getLockedById() {
        return this.lockedById;
    }

    public void setLockedById(long l) {
        this.lockedById = l;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(long l) {
        this.idleTime = l;
    }

    public long getAllowedIdleTime() {
        return this.allowedIdleTime;
    }

    public void setAllowedIdleTime(long l) {
        this.allowedIdleTime = l;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(Date date) {
        this.lastModificationDate = date;
    }

    public Collection getDistributions() {
        return this.distributions;
    }

    public void setDistributions(Collection collection) {
        this.distributions = collection;
    }

    public void emtpy() {
        super.emtpy();
        this.calendar = null;
        this.resources = null;
        this.tasks = null;
    }

    public boolean canBeUsed() {
        if (this.lockedById <= 0L) {
            return true;
        }
        ApplicationUser applicationUser = SessionFactory.getInstance().getSession(false).getUser();
        if (applicationUser == null || this.lockedById == applicationUser.getUniqueId()) {
            return true;
        }
        return this.idleTime > this.allowedIdleTime;
    }

    public boolean isLocked() {
        return this.lockedByName != null && this.lockedByName.length() > 0;
    }

    public String getLockerInfo() {
        String string = this.getLockedByName();
        if (string == null) {
            return null;
        }
        if (this.getIdleTime() > this.allowedIdleTime) {
            string = string + "(Idle: " + this.getIdleTime() / 60000L + "min)";
        }
        return string;
    }

    public final Map getFieldValues() {
        return this.fieldValues;
    }

    public final void setFieldValues(Map map) {
        this.fieldValues = map;
    }

    public final Map getExtraFields() {
        return this.extraFields;
    }

    public final void setExtraFields(Map map) {
        this.extraFields = map;
    }

    public final Collection getReferringSubprojectTasks() {
        return this.referringSubprojectTasks;
    }

    public final void setReferringSubprojectTasks(Collection collection) {
        this.referringSubprojectTasks = collection;
    }

    public long getAvailableImages() {
        return this.availableImages;
    }

    public void setAvailableImages(long l) {
        this.availableImages = l;
    }

    public Object getDelegatedFieldValue(Field field) {
        if (this.fieldValues == null) {
            return null;
        }
        return this.fieldValues.get(field.getId());
    }

    public boolean delegates(Field field) {
        return field != ProjectData.getGanttSnapshotField() && field != ProjectData.getNetworkSnapshotField() && !field.getId().equals("Field.creationDate") && !field.getId().equals("Field.lastModificationDate") && !field.getId().equals("Field.lockedByName") && !field.getId().equals("Field.locked") && !field.getId().equals("Field.name") && !field.getId().equals("Field.scheduleStatusIndicator") && !field.getId().equals("Field.statusIndicator") && !field.getId().equals("Field.budgetStatusIndicator");
    }

    public static Field getGanttSnapshotField() {
        if (ganttSnapshotFieldInstance == null) {
            ganttSnapshotFieldInstance = Configuration.getFieldFromId((String)"Field.ganttSnapshot");
        }
        return ganttSnapshotFieldInstance;
    }

    public ImageLink getGanttSnapshot() {
        return new ImageLink("Gantt Snapshot", "gantt", (this.availableImages & 0x21L) == 33L ? "/img/littleGantt.jpg" : "", "application.icon", "" + this.getUniqueId(), true);
    }

    public static Field getNetworkSnapshotField() {
        if (networkSnapshotFieldInstance == null) {
            networkSnapshotFieldInstance = Configuration.getFieldFromId((String)"Field.networkSnapshot");
        }
        return networkSnapshotFieldInstance;
    }

    public ImageLink getNetworkSnapshot() {
        return new ImageLink("Network Snapshot", "network", (this.availableImages & 0x30L) == 48L ? "/img/littleNetwork.png" : "", "network.icon", "" + this.getUniqueId(), true);
    }

    public ImageLink getScheduleStatusIndicator() {
        Double d = (Double)this.fieldValues.get("Field.spi");
        if (d == null) {
            d = new Double(0.0);
        }
        return EarnedValueCalculator.getInstance().getScheduleStatusIndicator(d.doubleValue());
    }

    public ImageLink getBudgetStatusIndicator() {
        Double d = (Double)this.fieldValues.get("Field.cpi");
        if (d == null) {
            d = new Double(0.0);
        }
        return EarnedValueCalculator.getInstance().getScheduleStatusIndicator(d.doubleValue());
    }

    public ImageLink getStatusIndicator() {
        Double d = (Double)this.fieldValues.get("Field.csi");
        if (d == null) {
            Double d2 = (Double)this.fieldValues.get("Field.spi");
            Double d3 = (Double)this.fieldValues.get("Field.cpi");
            d = d2 == null || d3 == null ? new Double(0.0) : new Double(d2 * d3);
        }
        return EarnedValueCalculator.getInstance().getStatusIndicator(d.doubleValue());
    }

    public String getDivision() {
        return this.division;
    }

    public void setDivision(String string) {
        this.division = string;
    }

    public int getExpenseType() {
        return this.expenseType;
    }

    public void setExpenseType(int n) {
        this.expenseType = n;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public int getProjectType() {
        return this.projectType;
    }

    public void setProjectType(int n) {
        this.projectType = n;
    }

    public int getProjectStatus() {
        return this.projectStatus;
    }

    public void setProjectStatus(int n) {
        this.projectStatus = n;
    }

    public String getName(FieldContext fieldContext) {
        return this.getName();
    }

    public int compareTo(Object object) {
        return this.getName().compareTo(((HasName)object).getName());
    }

    public int getAccessControlPolicy() {
        return this.accessControlPolicy;
    }

    public void setAccessControlPolicy(int n) {
        this.accessControlPolicy = n;
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float f) {
        this.version = f;
    }

    public long[] getUnchangedTasks() {
        return this.unchangedTasks;
    }

    public void setUnchangedTasks(long[] lArray) {
        this.unchangedTasks = lArray;
    }

    public long[] getUnchangedLinks() {
        return this.unchangedLinks;
    }

    public void setUnchangedLinks(long[] lArray) {
        this.unchangedLinks = lArray;
    }

    public boolean isIncrementalDistributions() {
        return this.incrementalDistributions;
    }

    public void setIncrementalDistributions(boolean bl) {
        this.incrementalDistributions = bl;
    }
}

