/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data;

import com.projity.configuration.CircularDependencyException;
import com.projity.configuration.Configuration;
import com.projity.datatype.Duration;
import com.projity.datatype.Rate;
import com.projity.exchange.Context;
import com.projity.exchange.ImportedCalendarService;
import com.projity.field.CustomFields;
import com.projity.grouping.core.VoidNodeImpl;
import com.projity.options.CalendarOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkDay;
import com.projity.pm.calendar.WorkRange;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.calendar.WorkingHours;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.server.data.CustomFieldsMapper;
import com.projity.strings.Messages;
import com.projity.util.DateTime;
import com.projity.util.MathUtils;
import com.sun.msv.datatype.xsd.DateTimeType;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.mspdi.DatatypeConverter;

public class MPXConverter {
    public static int nameFieldWidth = Configuration.getFieldFromId((String)"Field.name").getTextWidth();

    public static void toProjityProject(ProjectHeader projectHeader, Project project, Context context) {
        Object object;
        WorkCalendar workCalendar = null;
        String string = projectHeader.getCalendarName();
        if (workCalendar == null) {
            object = ImportedCalendarService.getInstance().findImportedMPXCalendar(projectHeader.getCalendarName());
            workCalendar = ImportedCalendarService.getInstance().findImportedCalendar((ProjectCalendar)object);
        }
        try {
            if (workCalendar != null) {
                project.setBaseCalendar(workCalendar);
            }
        }
        catch (CircularDependencyException circularDependencyException) {
            circularDependencyException.printStackTrace();
        }
        object = Messages.getString((String)"Text.Untitled");
        if (context.isXml()) {
            object = projectHeader.getProjectTitle();
            if ((object == null || ((String)object).trim().length() == 0) && (object = projectHeader.getName()) != null && ((String)object).endsWith(".xml")) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf(".xml"));
            }
        } else {
            object = projectHeader.getName();
        }
        if (object == null || ((String)object).length() == 0) {
            object = Messages.getString((String)"Text.Untitled");
        }
        project.setName(MPXConverter.truncName((String)object));
        project.setManager(projectHeader.getManager());
        project.setNotes(projectHeader.getComments());
        Project project2 = project;
        Date date = projectHeader.getStatusDate();
        if (date != null) {
            project.setStatusDate(DateTime.gmt((Date)date));
        }
    }

    public static void toProjityOptions(ProjectHeader projectHeader, Context context) {
        Comparable<Date> comparable;
        CalendarOption calendarOption = CalendarOption.getInstance();
        calendarOption.setHoursPerDay(projectHeader.getMinutesPerDay().doubleValue() / 60.0);
        calendarOption.setHoursPerWeek(projectHeader.getMinutesPerWeek().doubleValue() / 60.0);
        calendarOption.setDaysPerMonth(projectHeader.getDaysPerMonth().doubleValue());
        Date date = projectHeader.getDefaultStartTime();
        if (date != null) {
            comparable = new GregorianCalendar();
            ((Calendar)comparable).setTime(date);
            calendarOption.setDefaultStartTime(comparable);
        }
        if ((comparable = projectHeader.getDefaultEndTime()) != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime((Date)comparable);
            calendarOption.setDefaultEndTime(gregorianCalendar);
        }
    }

    public static void toMPXOptions(ProjectHeader projectHeader) {
        CalendarOption calendarOption = CalendarOption.getInstance();
        projectHeader.setMinutesPerDay(new Integer((int)(60.0 * calendarOption.getHoursPerDay())));
        projectHeader.setMinutesPerWeek(new Integer((int)(60.0 * calendarOption.getHoursPerWeek())));
        projectHeader.setDaysPerMonth(new Integer((int)Math.round(calendarOption.getDaysPerMonth())));
        projectHeader.setDefaultStartTime(calendarOption.getDefaultStartTime().getTime());
        projectHeader.setDefaultEndTime(calendarOption.getDefaultEndTime().getTime());
    }

    public static void toMPXProject(Project project, ProjectHeader projectHeader) {
        WorkCalendar workCalendar = project.getBaseCalendar();
        projectHeader.setCalendarName(workCalendar.getName());
        projectHeader.setName(project.getName());
        projectHeader.setProjectTitle(project.getName());
        projectHeader.setComments(project.getNotes());
        projectHeader.setManager(project.getManager());
        projectHeader.setComments(MPXConverter.removeInvalidChars(project.getNotes()));
        projectHeader.setStartDate(DateTime.fromGmt((Date)new Date(project.getStartDate())));
        projectHeader.setFinishDate(DateTime.fromGmt((Date)new Date(project.getFinishDate())));
        projectHeader.setDefaultStartTime(CalendarOption.getInstance().getDefaultStartTime().getTime());
        projectHeader.setDefaultEndTime(CalendarOption.getInstance().getDefaultEndTime().getTime());
    }

    public static void toProjityCalendar(ProjectCalendar projectCalendar, WorkingCalendar workingCalendar, Context context) {
        WorkCalendar workCalendar;
        if (projectCalendar.getName() != null) {
            workingCalendar.setName(projectCalendar.getName());
        }
        workingCalendar.setId((long)projectCalendar.getUniqueID().intValue());
        ProjectCalendar projectCalendar2 = null;
        WorkingCalendar workingCalendar2 = CalendarService.getInstance().getStandardInstance();
        if (!projectCalendar.isBaseCalendar()) {
            projectCalendar2 = projectCalendar.getBaseCalendar();
            if (projectCalendar2 == null) {
                projectCalendar2 = context.getDefaultMPXCalendar();
                projectCalendar.setBaseCalendar(projectCalendar2);
            }
            workCalendar = ImportedCalendarService.getInstance().findImportedCalendar(projectCalendar2);
            try {
                if (workCalendar == null) {
                    System.out.println("null base calendar");
                    workCalendar = workingCalendar2;
                }
                workingCalendar.setBaseCalendar(workCalendar);
            }
            catch (CircularDependencyException circularDependencyException) {
                circularDependencyException.printStackTrace();
            }
        }
        for (int i = 1; i <= 7; ++i) {
            Day day = Day.getInstance(i);
            ProjectCalendarHours projectCalendarHours = projectCalendar.getCalendarHours(day);
            if (projectCalendarHours == null) {
                workCalendar = null;
                if (projectCalendar.isBaseCalendar()) {
                    if (!projectCalendar.isWorkingDay(day) && workingCalendar2.getWeekDay(i - 1).isWorking()) {
                        workCalendar = WorkDay.getNonWorkingDay();
                    }
                } else if (!projectCalendar.isWorkingDay(day) && projectCalendar2 != null && projectCalendar2.isWorkingDay(day)) {
                    workCalendar = WorkDay.getNonWorkingDay();
                }
            } else {
                workCalendar = new WorkDay();
                MPXConverter.toProjityCalendarDay(projectCalendarHours, (WorkDay)workCalendar);
                if (projectCalendar.isBaseCalendar() && workingCalendar2.getWeekDay(i - 1).hasSameWorkHours((WorkDay)workCalendar)) {
                    workCalendar = null;
                }
            }
            workingCalendar.setWeekDay(i - 1, (WorkDay)workCalendar);
        }
        List list = projectCalendar.getCalendarExceptions();
        for (ProjectCalendarException projectCalendarException : list) {
            long l = DateTime.gmt((Date)projectCalendarException.getFromDate());
            long l2 = DateTime.gmt((Date)projectCalendarException.getToDate());
            long l3 = l;
            while (l3 < l2) {
                WorkDay workDay = new WorkDay(l3, l3);
                MPXConverter.toProjityExceptionDay(projectCalendarException, workDay);
                workingCalendar.addOrReplaceException(workDay);
                l3 = DateTime.nextDay((long)l3);
            }
        }
        workingCalendar.removeEmptyDays();
    }

    public static void toMpxCalendar(WorkingCalendar workingCalendar, ProjectCalendar projectCalendar) {
        WorkCalendar workCalendar;
        Object object;
        Object object2;
        projectCalendar.setName(workingCalendar.getName());
        WorkingCalendar workingCalendar2 = workingCalendar;
        if (workingCalendar.isBaseCalendar()) {
            workingCalendar2 = (WorkingCalendar)workingCalendar.getBaseCalendar();
        }
        for (int i = 0; i < 7; ++i) {
            WorkDay workDay = workingCalendar.isBaseCalendar() ? workingCalendar.getDerivedWeekDay(i) : workingCalendar.getWeekDay(i);
            object2 = null;
            object = Day.getInstance(i + 1);
            if (workDay == null) {
                projectCalendar.setWorkingDay((Day)object, 2);
                continue;
            }
            projectCalendar.setWorkingDay((Day)object, workDay.isWorking());
            if (!workDay.isWorking()) continue;
            object2 = projectCalendar.addCalendarHours(Day.getInstance(i + 1));
            MPXConverter.toMpxCalendarDay(workDay, (ProjectCalendarHours)object2);
        }
        WorkDay[] workDayArray = workingCalendar.getExceptionDays();
        if (workDayArray != null) {
            for (int i = 0; i < workDayArray.length; ++i) {
                if (workDayArray[i] == null || workDayArray[i].getStart() == 0L || workDayArray[i].getStart() == Long.MAX_VALUE) continue;
                object2 = projectCalendar.addCalendarException();
                object = new Date(workDayArray[i].getStart());
                ((ProjectCalendarException)object2).setFromDate((Date)object);
                GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
                gregorianCalendar.setTime((Date)object);
                gregorianCalendar.set(10, 23);
                gregorianCalendar.set(12, 59);
                ((ProjectCalendarException)object2).setToDate(DateTime.fromGmt((Date)gregorianCalendar.getTime()));
                MPXConverter.toMpxExceptionDay(workDayArray[i], (ProjectCalendarException)object2);
                ((ProjectCalendarException)object2).setWorking(workDayArray[i].isWorking());
            }
        }
        if ((workCalendar = workingCalendar.getBaseCalendar()) != null) {
            projectCalendar.setBaseCalendar(ImportedCalendarService.getInstance().findExportedCalendar(workCalendar));
        }
    }

    public static void toProjityCalendarDay(ProjectCalendarHours projectCalendarHours, WorkDay workDay) {
        WorkingHours workingHours = new WorkingHours();
        if (projectCalendarHours == null) {
            return;
        }
        DateRange dateRange = projectCalendarHours.getDateRange(0);
        if (dateRange != null) {
            workingHours.setInterval(0, dateRange.getStartDate(), dateRange.getEndDate());
        }
        if ((dateRange = projectCalendarHours.getDateRange(1)) != null) {
            workingHours.setInterval(1, dateRange.getStartDate(), dateRange.getEndDate());
        }
        if ((dateRange = projectCalendarHours.getDateRange(2)) != null) {
            workingHours.setInterval(2, dateRange.getStartDate(), dateRange.getEndDate());
        }
        workDay.setWorkingHours(workingHours);
    }

    public static void toMpxCalendarDay(WorkDay workDay, ProjectCalendarHours projectCalendarHours) {
        if (workDay == null) {
            return;
        }
        WorkingHours workingHours = workDay.getWorkingHours();
        for (int i = 0; i < 3; ++i) {
            WorkRange workRange = workingHours.getInterval(i);
            if (workRange == null) continue;
            projectCalendarHours.addDateRange(new DateRange(DateTime.fromGmt((Date)workRange.getNormalizedStartTime()), DateTime.fromGmt((Date)workRange.getNormalizedEndTime())));
        }
    }

    public static void toProjityExceptionDay(ProjectCalendarException projectCalendarException, WorkDay workDay) {
        WorkingHours workingHours = new WorkingHours();
        if (projectCalendarException == null) {
            return;
        }
        workingHours.setInterval(0, projectCalendarException.getFromTime1(), projectCalendarException.getToTime1());
        workingHours.setInterval(1, projectCalendarException.getFromTime2(), projectCalendarException.getToTime2());
        workingHours.setInterval(2, projectCalendarException.getFromTime3(), projectCalendarException.getToTime3());
        workDay.setWorkingHours(workingHours);
    }

    public static void toMpxExceptionDay(WorkDay workDay, ProjectCalendarException projectCalendarException) {
        if (workDay == null) {
            return;
        }
        WorkingHours workingHours = workDay.getWorkingHours();
        WorkRange workRange = workingHours.getInterval(0);
        if (workRange != null) {
            projectCalendarException.setFromTime1(DateTime.fromGmt((Date)workRange.getNormalizedStartTime()));
            projectCalendarException.setToTime1(DateTime.fromGmt((Date)workRange.getNormalizedEndTime()));
        }
        if ((workRange = workingHours.getInterval(1)) != null) {
            projectCalendarException.setFromTime2(DateTime.fromGmt((Date)workRange.getNormalizedStartTime()));
            projectCalendarException.setToTime2(DateTime.fromGmt((Date)workRange.getNormalizedEndTime()));
        }
        if ((workRange = workingHours.getInterval(2)) != null) {
            projectCalendarException.setFromTime3(DateTime.fromGmt((Date)workRange.getNormalizedStartTime()));
            projectCalendarException.setToTime3(DateTime.fromGmt((Date)workRange.getNormalizedEndTime()));
        }
    }

    public static void toProjityResource(Resource resource, ResourceImpl resourceImpl, Context context) {
        resourceImpl.setName(MPXConverter.truncName(resource.getName()));
        resourceImpl.setNotes(resource.getNotes());
        resourceImpl.setAccrueAt(resource.getAccrueAt().getType());
        resourceImpl.setCostPerUse(resource.getCostPerUse().doubleValue());
        resourceImpl.setStandardRate(MPXConverter.toProjityRate(resource.getStandardRate()));
        resourceImpl.setOvertimeRate(MPXConverter.toProjityRate(resource.getOvertimeRate()));
        resourceImpl.setGeneric(resource.getGeneric());
        resourceImpl.setGroup(resource.getGroup());
        resourceImpl.setInitials(resource.getInitials());
        resourceImpl.setEmailAddress(resource.getEmailAddress());
        resourceImpl.setId((long)resource.getID().intValue());
        resourceImpl.setExternalId((long)resource.getUniqueID().intValue());
        resourceImpl.setMaximumUnits(resource.getMaxUnits().doubleValue());
        ProjectCalendar projectCalendar = resource.getResourceCalendar();
        WorkingCalendar workingCalendar = WorkingCalendar.getInstance();
        workingCalendar.setName(resourceImpl.getName());
        if (projectCalendar != null) {
            MPXConverter.toProjityCalendar(projectCalendar, workingCalendar, context);
        } else {
            try {
                workingCalendar.setBaseCalendar((WorkCalendar)CalendarService.getInstance().getDefaultInstance());
            }
            catch (CircularDependencyException circularDependencyException) {
                circularDependencyException.printStackTrace();
            }
        }
        resourceImpl.setWorkCalendar((WorkCalendar)workingCalendar);
        MPXConverter.toProjityCustomFields(resourceImpl.getCustomFields(), resource, CustomFieldsMapper.getInstance().resourceMaps, context);
    }

    public static void toMPXResource(ResourceImpl resourceImpl, Resource resource) {
        resource.setName(MPXConverter.removeInvalidChars(resourceImpl.getName()));
        resource.setNotes(MPXConverter.removeInvalidChars(resourceImpl.getNotes()));
        resource.setAccrueAt(AccrueType.getInstance(resourceImpl.getAccrueAt()));
        resource.setCostPerUse(new Double(resourceImpl.getCostPerUse()));
        resource.setStandardRate(MPXConverter.toMPXRate(resourceImpl.getStandardRate()));
        resource.setOvertimeRate(MPXConverter.toMPXRate(resourceImpl.getOvertimeRate()));
        resource.setGroup(resourceImpl.getGroup());
        resource.setEmailAddress(resourceImpl.getEmailAddress());
        resource.setIsGeneric(resourceImpl.isGeneric());
        resource.setInitials(resourceImpl.getInitials());
        resource.setID((int)resourceImpl.getId());
        long l = resourceImpl.getExternalId();
        if (l <= 0L) {
            l = resourceImpl.getId();
        }
        resource.setUniqueID((int)l);
        resource.setMaxUnits(resourceImpl.getMaximumUnits());
        WorkingCalendar workingCalendar = (WorkingCalendar)resourceImpl.getWorkCalendar();
        if (workingCalendar != null) {
            ProjectCalendar projectCalendar = null;
            try {
                projectCalendar = resource.addResourceCalendar();
            }
            catch (MPXJException mPXJException) {
                mPXJException.printStackTrace();
                return;
            }
            MPXConverter.toMpxCalendar(workingCalendar, projectCalendar);
        }
        MPXConverter.toMpxCustomFields(resourceImpl.getCustomFields(), resource, CustomFieldsMapper.getInstance().resourceMaps);
    }

    public static void toProjityCustomFields(CustomFields customFields, FieldContainer fieldContainer, CustomFieldsMapper.Maps maps, Context context) {
        Object object;
        int n;
        for (n = 0; n < maps.costMap.length; ++n) {
            object = (Number)fieldContainer.getCurrentValue(maps.costMap[n]);
            if (object == null) continue;
            customFields.setCustomCost(n, ((Number)object).doubleValue());
        }
        for (n = 0; n < maps.dateMap.length; ++n) {
            object = (Date)fieldContainer.getCurrentValue(maps.dateMap[n]);
            if (object == null) continue;
            customFields.setCustomDate(n, ((Date)object).getTime());
        }
        for (n = 0; n < maps.durationMap.length; ++n) {
            object = (net.sf.mpxj.Duration)fieldContainer.getCurrentValue(maps.durationMap[n]);
            if (object == null) continue;
            customFields.setCustomDuration(n, MPXConverter.toProjityDuration((net.sf.mpxj.Duration)object, context));
        }
        for (n = 0; n < maps.finishMap.length; ++n) {
            object = (Date)fieldContainer.getCurrentValue(maps.finishMap[n]);
            if (object == null) continue;
            customFields.setCustomFinish(n, ((Date)object).getTime());
        }
        for (n = 0; n < maps.flagMap.length; ++n) {
            object = (Boolean)fieldContainer.getCurrentValue(maps.flagMap[n]);
            if (object == null) continue;
            customFields.setCustomFlag(n, ((Boolean)object).booleanValue());
        }
        for (n = 0; n < maps.numberMap.length; ++n) {
            object = (Number)fieldContainer.getCurrentValue(maps.numberMap[n]);
            if (object == null) continue;
            customFields.setCustomNumber(n, ((Number)object).doubleValue());
        }
        for (n = 0; n < maps.startMap.length; ++n) {
            object = (Date)fieldContainer.getCurrentValue(maps.startMap[n]);
            if (object == null) continue;
            customFields.setCustomStart(n, ((Date)object).getTime());
        }
        for (n = 0; n < maps.textMap.length; ++n) {
            object = (String)fieldContainer.getCurrentValue(maps.textMap[n]);
            if (object == null) continue;
            customFields.setCustomText(n, (String)object);
        }
    }

    public static void toMpxCustomFields(CustomFields customFields, FieldContainer fieldContainer, CustomFieldsMapper.Maps maps) {
        int n;
        for (n = 0; n < maps.costMap.length; ++n) {
            double d = customFields.getCustomCost(n);
            if (d == 0.0) continue;
            fieldContainer.set(maps.costMap[n], new Double(d));
        }
        for (n = 0; n < maps.dateMap.length; ++n) {
            long l = customFields.getCustomDate(n);
            if (l == 0L) continue;
            fieldContainer.set(maps.dateMap[n], new Date(l));
        }
        for (n = 0; n < maps.durationMap.length; ++n) {
            long l = customFields.getCustomDuration(n);
            if (Duration.millis((long)l) == 0L) continue;
            fieldContainer.set(maps.durationMap[n], MPXConverter.toMPXDuration(l));
        }
        for (n = 0; n < maps.finishMap.length; ++n) {
            long l = customFields.getCustomFinish(n);
            if (l == 0L) continue;
            fieldContainer.set(maps.finishMap[n], new Date(l));
        }
        for (n = 0; n < maps.flagMap.length; ++n) {
            boolean bl = customFields.getCustomFlag(n);
            if (!bl) continue;
            fieldContainer.set(maps.flagMap[n], Boolean.TRUE);
        }
        for (n = 0; n < maps.numberMap.length; ++n) {
            double d = customFields.getCustomNumber(n);
            if (d == 0.0) continue;
            fieldContainer.set(maps.numberMap[n], new Double(d));
        }
        for (n = 0; n < maps.startMap.length; ++n) {
            long l = customFields.getCustomStart(n);
            if (l == 0L) continue;
            fieldContainer.set(maps.startMap[n], new Date(l));
        }
        for (n = 0; n < maps.textMap.length; ++n) {
            String string = customFields.getCustomText(n);
            if (string == null) continue;
            fieldContainer.set(maps.textMap[n], MPXConverter.removeInvalidChars(string));
        }
    }

    public static void toMPXAssignment(Assignment assignment, ResourceAssignment resourceAssignment) {
        long l;
        long l2 = assignment.getWork(null);
        resourceAssignment.setWork(MPXConverter.toMPXDuration(l2));
        resourceAssignment.setUnits(MathUtils.roundToDecentPrecision((double)(assignment.getUnits() * 100.0)));
        resourceAssignment.setRemainingWork(MPXConverter.toMPXDuration(assignment.getRemainingWork()));
        long l3 = Duration.millis((long)assignment.getDelay());
        if (l3 != 0L) {
            CalendarOption calendarOption = CalendarOption.getInstance();
            CalendarOption.setInstance((CalendarOption)CalendarOption.getDefaultInstance());
            resourceAssignment.setDelay(MPXConverter.toMPXDuration(assignment.getDelay()));
            CalendarOption.setInstance((CalendarOption)calendarOption);
        }
        if ((l = Duration.millis((long)assignment.getLevelingDelay())) != 0L) {
            CalendarOption calendarOption = CalendarOption.getInstance();
            CalendarOption.setInstance((CalendarOption)CalendarOption.getDefaultInstance());
            resourceAssignment.setDelay(MPXConverter.toMPXDuration(assignment.getLevelingDelay()));
            CalendarOption.setInstance((CalendarOption)calendarOption);
        }
        resourceAssignment.setWorkContour(WorkContour.getInstance(assignment.getWorkContourType()));
    }

    public static void toProjityTask(Task task, NormalTask normalTask, Context context) {
        Object object;
        ProjectCalendar projectCalendar;
        Number number;
        Priority priority;
        normalTask.setName(MPXConverter.truncName(task.getName()));
        if (task.getWBS() != null) {
            normalTask.setWbs(task.getWBS());
        }
        normalTask.setNotes(task.getNotes());
        normalTask.getCurrentSchedule().setStart(DateTime.gmt((Date)task.getStart()));
        normalTask.getCurrentSchedule().setFinish(DateTime.gmt((Date)task.getFinish()));
        normalTask.setId((long)task.getID().intValue());
        normalTask.setCreated(MPXConverter.toNormalDate(task.getCreateDate()));
        normalTask.setDuration(MPXConverter.toProjityDuration(task.getDuration(), context));
        normalTask.setEstimated(task.getEstimated());
        if (task.getDeadline() != null) {
            normalTask.setDeadline(DateTime.gmt((Date)task.getDeadline()));
        }
        if ((priority = task.getPriority()) != null) {
            normalTask.setPriority(task.getPriority().getValue());
        }
        if ((number = task.getFixedCost()) != null) {
            normalTask.setFixedCost(number.doubleValue());
        }
        Date date = DateTime.gmtDate((Date)task.getConstraintDate());
        ConstraintType constraintType = task.getConstraintType();
        if (constraintType != null) {
            normalTask.setScheduleConstraint(constraintType.getType(), date == null ? 0L : date.getTime());
        }
        if ((projectCalendar = task.getCalendar()) != null) {
            object = ImportedCalendarService.getInstance().findImportedCalendar(projectCalendar);
            if (object == null) {
                System.out.println("Error finding imported calendar " + projectCalendar.getName());
            } else {
                normalTask.setWorkCalendar((WorkCalendar)object);
            }
        }
        if (task.getStop() != null) {
            normalTask.setStop(DateTime.gmt((Date)task.getStop()));
        }
        normalTask.setLevelingDelay(MPXConverter.toProjityDuration(task.getLevelingDelay(), context));
        normalTask.setEffortDriven(task.getEffortDriven());
        if (task.getType() != null) {
            normalTask.setSchedulingType(task.getType().getValue());
        }
        if ((object = task.getFixedCost()) != null) {
            normalTask.setFixedCost(((Number)object).doubleValue());
        }
        normalTask.setFixedCostAccrual(task.getFixedCostAccrual().getType());
        if (!normalTask.isMilestone() && task.getMilestone()) {
            normalTask.setMarkTaskAsMilestone(true);
        }
        if (task.getEarnedValueMethod() != null) {
            normalTask.setEarnedValueMethod(task.getEarnedValueMethod().getValue());
        }
        normalTask.setIgnoreResourceCalendar(task.getIgnoreResourceCalendar());
        MPXConverter.toProjityCustomFields(normalTask.getCustomFields(), task, CustomFieldsMapper.getInstance().taskMaps, context);
    }

    public static String removeInvalidChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c != '\r' && c != '\n' && c != '\t') continue;
            stringBuffer.setCharAt(i, ' ');
        }
        return stringBuffer.toString();
    }

    public static void toMPXTask(NormalTask normalTask, Task task) {
        WorkCalendar workCalendar;
        task.setName(MPXConverter.removeInvalidChars(normalTask.getName()));
        if (normalTask.getWbs() != null) {
            task.setWBS(MPXConverter.removeInvalidChars(normalTask.getWbs()));
        }
        task.setNotes(MPXConverter.removeInvalidChars(normalTask.getNotes()));
        task.setID((int)normalTask.getId());
        task.setUniqueID((int)normalTask.getId());
        task.setCreateDate(normalTask.getCreated());
        task.setDuration(MPXConverter.toMPXDuration(normalTask.getDuration()));
        task.setStart(DateTime.fromGmt((Date)new Date(normalTask.getStart())));
        task.setFinish(DateTime.fromGmt((Date)new Date(normalTask.getEnd())));
        task.setCritical(new Boolean(normalTask.isCritical()));
        task.setEstimated(normalTask.isEstimated());
        task.setEffortDriven(normalTask.isEffortDriven());
        task.setType(TaskType.getInstance(normalTask.getSchedulingType()));
        task.setConstraintType(ConstraintType.getInstance(normalTask.getConstraintType()));
        task.setConstraintDate(DateTime.fromGmt((Date)new Date(normalTask.getConstraintDate())));
        task.setPriority(Priority.getInstance(normalTask.getPriority()));
        task.setFixedCost(normalTask.getFixedCost());
        task.setFixedCostAccrual(AccrueType.getInstance(normalTask.getFixedCostAccrual()));
        task.setMilestone(normalTask.isMarkTaskAsMilestone());
        task.setLevelingDelay(MPXConverter.toMPXDuration(normalTask.getLevelingDelay()));
        if (normalTask.getDeadline() != 0L) {
            task.setDeadline(DateTime.fromGmt((Date)new Date(normalTask.getDeadline())));
        }
        task.setEarnedValueMethod(EarnedValueMethod.getInstance(normalTask.getEarnedValueMethod()));
        task.setIgnoreResourceCalendar(normalTask.isIgnoreResourceCalendar());
        task.setTotalSlack(MPXConverter.toMPXDuration(normalTask.getTotalSlack()));
        task.setRemainingDuration(MPXConverter.toMPXDuration(normalTask.getRemainingDuration()));
        if (normalTask.getStop() != 0L) {
            task.setStop(DateTime.fromGmt((Date)new Date(normalTask.getStop())));
        }
        if ((workCalendar = normalTask.getWorkCalendar()) != null) {
            task.setCalendar(ImportedCalendarService.getInstance().findExportedCalendar(workCalendar));
        }
        MPXConverter.toMpxCustomFields(normalTask.getCustomFields(), task, CustomFieldsMapper.getInstance().taskMaps);
    }

    public static void toMPXVoid(VoidNodeImpl voidNodeImpl, Task task) {
        task.setID((int)voidNodeImpl.getId());
        task.setUniqueID((int)voidNodeImpl.getId());
        task.setNull(true);
        task.setCritical(false);
        task.setTotalSlack(MPXConverter.toMPXDuration(0L));
    }

    public static long toProjityDate(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public static Date toNormalDate(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(DateTime.gmt((Date)date));
    }

    public static Rate toProjityRate(net.sf.mpxj.Rate rate) {
        double d = rate.getAmount() / Duration.timeUnitFactor((int)rate.getUnits().getValue());
        return new Rate(d, rate.getUnits().getValue());
    }

    public static net.sf.mpxj.Rate toMPXRate(Rate rate) {
        double d = rate.getValue() * Duration.timeUnitFactor((int)rate.getTimeUnit());
        return new net.sf.mpxj.Rate(d, TimeUnit.getInstance(rate.getTimeUnit()));
    }

    public static long toProjityDuration(net.sf.mpxj.Duration duration, Context context) {
        long l = 0L;
        if (duration == null) {
            return 0L;
        }
        if (context.isXml()) {
            CalendarOption calendarOption = CalendarOption.getInstance();
            CalendarOption.setInstance((CalendarOption)CalendarOption.getDefaultInstance());
            l = Duration.getInstance((double)duration.getDuration(), (int)duration.getUnits().getValue());
            CalendarOption.setInstance((CalendarOption)calendarOption);
        } else {
            l = Duration.getInstance((double)duration.getDuration(), (int)duration.getUnits().getValue());
        }
        return l;
    }

    public static net.sf.mpxj.Duration toMPXDuration(long l) {
        return net.sf.mpxj.Duration.getInstance(Duration.getValue((long)l), TimeUnit.getInstance(Duration.getType((long)l)));
    }

    public static final String dateToXMLString(long l) {
        Calendar calendar = DatatypeConverter.printDate(new Date(l));
        String string = DateTimeType.theInstance.serializeJavaObject(calendar, null);
        return string;
    }

    private static String truncName(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() > nameFieldWidth) {
            string = string.substring(0, nameFieldWidth);
        }
        return string;
    }
}

