/*
 * Decompiled with CFR 0.152.
 */
package com.projity.exchange;

import com.projity.association.InvalidAssociationException;
import com.projity.configuration.CircularDependencyException;
import com.projity.configuration.Settings;
import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.exchange.Context;
import com.projity.exchange.ImportedCalendarService;
import com.projity.exchange.ResourceMappingForm;
import com.projity.exchange.ServerFileImporter;
import com.projity.functor.StringList;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.model.NodeModel;
import com.projity.job.Job;
import com.projity.job.JobCanceledException;
import com.projity.job.JobRunnable;
import com.projity.options.CalendarOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.AssignmentService;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.dependency.HasDependencies;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.resource.ResourcePool;
import com.projity.pm.task.NormalTask;
import com.projity.server.access.ErrorLogger;
import com.projity.server.data.EnterpriseResourceData;
import com.projity.server.data.MPXConverter;
import com.projity.server.data.MSPDISerializer;
import com.projity.server.data.Serializer;
import com.projity.server.data.mspdi.ModifiedMSPDIReader;
import com.projity.session.LocalSession;
import com.projity.session.Session;
import com.projity.session.SessionFactory;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.DateTime;
import com.projity.util.Environment;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.Task;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.planner.PlannerReader;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

public class MicrosoftImporter
extends ServerFileImporter {
    static Log log = LogFactory.getLog(MicrosoftImporter.class);
    ProjectFile mpx = null;
    AbstractProjectReader reader;
    List allTasks = null;
    ArrayList subprojects;
    private Date earliestStart = DateTime.getMaxDate();
    private HashMap taskMap = new HashMap();
    private HashMap resourceMap = new HashMap();
    List allResources = null;
    public static final boolean ADD_SUMMARY_TASK = false;
    Task dummyFirstTask = null;
    private static final String ERROR_XML = Messages.getString((String)"MicrosoftImporter.ErrorImportingXML");
    private static final String ABORT = "Job aborted";
    private String errorDescription = null;
    private Exception lastException = null;
    private Context context = new Context();
    private static String[] fileSuffixes = new String[]{"", ".xml", ".mpp", ".mpx", ".planner"};

    public Job getImportFileJob() {
        this.subprojects = new ArrayList();
        this.errorDescription = null;
        this.lastException = null;
        Session session = SessionFactory.getInstance().getSession(this.resourceMapping == null);
        Job job = new Job(session.getJobQueue(), "importFile", Messages.getString((String)"MicrosoftImporter.Importing"), true);
        job.addRunnable(new JobRunnable(Messages.getString((String)"MicrosoftImporter.PrepareResources"), 1.0f){

            public Object run() throws Exception {
                String string;
                Environment.setImporting((boolean)true);
                log.info("doing file import");
                InputStream inputStream = null;
                this.setProgress(0.05f);
                int n = MicrosoftImporter.this.fileName.lastIndexOf(".");
                if (MicrosoftImporter.this.fileName.startsWith("http")) {
                    MicrosoftImporter.this.fileName = URLDecoder.decode(MicrosoftImporter.this.fileName, "UTF-8");
                    if (MicrosoftImporter.this.fileName.startsWith("http://")) {
                        inputStream = new URL(MicrosoftImporter.this.fileName).openStream();
                    }
                } else {
                    string = MicrosoftImporter.this.fileName;
                    for (int i = 0; i < fileSuffixes.length; ++i) {
                        MicrosoftImporter.this.fileName = string + fileSuffixes[i];
                        try {
                            inputStream = new FileInputStream(MicrosoftImporter.this.fileName);
                            break;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            continue;
                        }
                    }
                }
                if (inputStream == null) {
                    Alert.warn((Object)Messages.getString((String)"Warn.fileNotFound"));
                    throw new JobCanceledException(MicrosoftImporter.ABORT);
                }
                string = n == -1 ? "xml" : MicrosoftImporter.this.fileName.substring(n + 1).toLowerCase();
                if (string.equals("mpp")) {
                    MicrosoftImporter.this.reader = new MPPReader();
                    try {
                        MicrosoftImporter.this.mpx = MicrosoftImporter.this.reader.read(inputStream);
                    }
                    catch (Exception exception) {
                        MicrosoftImporter.this.lastException = exception;
                        ErrorLogger.log((String)("Exception importing " + string + " file"), (Exception)exception);
                        MicrosoftImporter.this.mpx = null;
                    }
                } else if (string.equals("mpx")) {
                    MicrosoftImporter.this.reader = new MPXReader();
                    try {
                        MicrosoftImporter.this.mpx = MicrosoftImporter.this.reader.read(inputStream);
                    }
                    catch (Exception exception) {
                        MicrosoftImporter.this.lastException = exception;
                        ErrorLogger.log((String)("Exception importing " + string + " file"), (Exception)exception);
                        MicrosoftImporter.this.mpx = null;
                    }
                } else if (string.equals("xml")) {
                    try {
                        MicrosoftImporter.this.context.setXml(true);
                        MicrosoftImporter.this.reader = new ModifiedMSPDIReader();
                        MicrosoftImporter.this.mpx = MicrosoftImporter.this.reader.read(inputStream);
                    }
                    catch (Exception exception) {
                        MicrosoftImporter.this.lastException = exception;
                        System.out.println("Can't read xml: " + exception.getMessage());
                        exception.printStackTrace();
                        MicrosoftImporter.this.mpx = null;
                        MicrosoftImporter.this.errorDescription = ERROR_XML;
                    }
                } else if (string.equals("planner")) {
                    MicrosoftImporter.this.reader = new PlannerReader();
                    try {
                        MicrosoftImporter.this.mpx = MicrosoftImporter.this.reader.read(inputStream);
                    }
                    catch (Exception exception) {
                        MicrosoftImporter.this.lastException = exception;
                        ErrorLogger.log((String)("Exception importing " + string + " file"), (Exception)exception);
                        MicrosoftImporter.this.mpx = null;
                    }
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (MicrosoftImporter.this.mpx == null) {
                    String string2 = MicrosoftImporter.this.errorDescription == null ? Messages.getString((String)"Message.ImportError") : MicrosoftImporter.this.errorDescription;
                    this.job.error(string2, false);
                    this.job.cancel();
                    Environment.setImporting((boolean)false);
                    throw MicrosoftImporter.this.lastException == null ? new Exception("Failed to import file") : MicrosoftImporter.this.lastException;
                }
                this.setProgress(0.2f);
                log.info("prepare resources");
                MicrosoftImporter.this.allResources = MicrosoftImporter.this.mpx.getAllResources();
                MicrosoftImporter.this.prepareResources(MicrosoftImporter.this.mpx.getAllResources(), new Predicate(){

                    public boolean evaluate(Object object) {
                        Integer n;
                        net.sf.mpxj.Resource resource = (net.sf.mpxj.Resource)object;
                        return resource != null && (n = resource.getID()) != null && n.longValue() != 0L;
                    }
                }, true);
                this.setProgress(1.0f);
                return null;
            }
        });
        job.addSwingRunnable(new JobRunnable("Import resources", 1.0f){

            public Object run() throws Exception {
                ResourceMappingForm resourceMappingForm = MicrosoftImporter.this.getResourceMapping();
                if (resourceMappingForm != null && resourceMappingForm.isLocal() && !this.job.okCancel(Messages.getString((String)"Message.ServerUnreacheableReadOnlyProject"), true)) {
                    this.setProgress(1.0f);
                    MicrosoftImporter.this.errorDescription = MicrosoftImporter.ABORT;
                    Environment.setImporting((boolean)false);
                    throw new Exception(MicrosoftImporter.ABORT);
                }
                log.info("import resources");
                if (!MicrosoftImporter.this.importResources()) {
                    this.setProgress(1.0f);
                    MicrosoftImporter.this.errorDescription = MicrosoftImporter.ABORT;
                    Environment.setImporting((boolean)false);
                    throw new Exception(MicrosoftImporter.ABORT);
                }
                this.setProgress(1.0f);
                return null;
            }
        });
        job.addRunnable(new JobRunnable("Finish import", 1.0f){

            public Object run() throws Exception {
                block5: {
                    log.info("import options");
                    MicrosoftImporter.this.importOptions();
                    this.setProgress(0.45f);
                    log.info("import calendars");
                    MicrosoftImporter.this.importCalendars();
                    this.setProgress(0.5f);
                    log.info("import tasks");
                    MicrosoftImporter.this.importTasks();
                    this.setProgress(0.6f);
                    log.info("import project fields");
                    MicrosoftImporter.this.importProjectFields();
                    this.setProgress(0.7f);
                    log.info("import dependencies");
                    MicrosoftImporter.this.importDependencies();
                    this.setProgress(0.8f);
                    log.info("import hierarchy");
                    MicrosoftImporter.this.importHierarchy();
                    this.setProgress(0.85f);
                    log.info("import assignments");
                    MicrosoftImporter.this.importAssignments();
                    this.setProgress(0.9f);
                    log.info("about to initialize");
                    if (MicrosoftImporter.this.project.getName() == null) {
                        MicrosoftImporter.this.project.setName("error - name not set on import");
                    }
                    try {
                        MicrosoftImporter.this.project.initialize(false, false);
                    }
                    catch (RuntimeException runtimeException) {
                        if (runtimeException.getMessage() != CircularDependencyException.RUNTIME_EXCEPTION_TEXT) break block5;
                        Environment.setImporting((boolean)false);
                        Alert.error((Object)runtimeException.getMessage());
                        MicrosoftImporter.this.mpx = null;
                        MicrosoftImporter.this.project = null;
                        throw new Exception(runtimeException.getMessage());
                    }
                }
                if (!Environment.getStandAlone()) {
                    MicrosoftImporter.this.project.setAllDirty();
                }
                MicrosoftImporter.this.project.setBoundsAfterReadProject();
                if (MicrosoftImporter.this.mpx.getProjectHeader().getScheduleFrom() == ScheduleFrom.FINISH) {
                    MicrosoftImporter.this.project.setForward(false);
                }
                Environment.setImporting((boolean)false);
                this.setProgress(1.0f);
                MicrosoftImporter.this.mpx = null;
                return MicrosoftImporter.this.project;
            }
        });
        return job;
    }

    private void importCalendars() {
        List list = this.mpx.getBaseCalendars();
        Iterator iterator = list.iterator();
        ImportedCalendarService importedCalendarService = ImportedCalendarService.getInstance();
        String string = " " + Settings.LEFT_BRACKET + this.mpx.getProjectHeader().getProjectTitle() + Settings.RIGHT_BRACKET;
        while (iterator.hasNext()) {
            ProjectCalendar projectCalendar = (ProjectCalendar)iterator.next();
            if ("Standard".equals(projectCalendar.getName())) {
                this.context.setDefaultMPXCalendar(projectCalendar);
            }
            WorkingCalendar workingCalendar = WorkingCalendar.getStandardBasedInstance();
            MPXConverter.toProjityCalendar(projectCalendar, workingCalendar, this.context);
            if (CalendarService.findBaseCalendar((String)workingCalendar.getName()) != null) {
                workingCalendar.setName(workingCalendar.getName() + string);
            }
            importedCalendarService.addImportedCalendar(workingCalendar, projectCalendar);
        }
    }

    private void importLocalResources() {
        ResourcePool resourcePool = this.project.getResourcePool();
        this.project.setLocal(true);
        resourcePool.setLocal(true);
        resourcePool.setMaster(false);
        resourcePool.updateOutlineTypes();
        for (net.sf.mpxj.Resource resource : this.allResources) {
            if (resource.getNull() || resource.getID() == null) continue;
            if (resource.getID() == 0) {
                this.resourceMap.put(resource, ResourceImpl.getUnassignedInstance());
                continue;
            }
            ResourceImpl resourceImpl = resourcePool.newResourceInstance();
            this.resourceMap.put(resource, resourceImpl);
            MPXConverter.toProjityResource(resource, resourceImpl, this.context);
            resourceImpl.getGlobalResource().setLocal(true);
            if (resourceImpl.getBaseCalendar() == null) {
                try {
                    resourceImpl.setBaseCalendar(this.project.getBaseCalendar());
                }
                catch (CircularDependencyException circularDependencyException) {
                    circularDependencyException.printStackTrace();
                }
            }
            Node node = NodeFactory.getInstance().createNode((Object)resourceImpl);
            resourcePool.addToDefaultOutline(null, node);
        }
        this.insertResourceVoids();
    }

    protected boolean importResources() throws Exception {
        return this.importResources(this.resourceMap, new Closure(){

            public void execute(Object object) {
                MicrosoftImporter.this.importLocalResources();
            }
        });
    }

    protected boolean importResources(HashMap hashMap, Closure closure) throws Exception {
        ResourceMappingForm resourceMappingForm = this.getResourceMapping();
        if (resourceMappingForm == null || resourceMappingForm.isLocal()) {
            closure.execute(null);
        } else {
            Node node;
            if (!resourceMappingForm.execute()) {
                return false;
            }
            if (resourceMappingForm.isLocal()) {
                closure.execute(null);
                return true;
            }
            Resource resource = null;
            int n = 0;
            ResourcePool resourcePool = this.project.getResourcePool();
            this.project.setTemporaryLocal(true);
            HashMap<EnterpriseResourceData, Resource> hashMap2 = new HashMap<EnterpriseResourceData, Resource>();
            for (EnterpriseResourceData enterpriseResourceData : resourceMappingForm.getResources()) {
                if (enterpriseResourceData.isLocal()) {
                    resource = ResourceImpl.getUnassignedInstance();
                } else {
                    resource = Serializer.deserializeResourceAndAddToPool(enterpriseResourceData, resourcePool, null);
                    node = NodeFactory.getInstance().createNode((Object)resource);
                    resourcePool.addToDefaultOutline(null, node, n++, false);
                    ((ResourceImpl)resource).getGlobalResource().setResourcePool(resourcePool);
                }
                hashMap2.put(enterpriseResourceData, resource);
            }
            Iterator iterator = resourceMappingForm.getImportedResources().iterator();
            node = resourceMappingForm.getSelectedResources().iterator();
            while (iterator.hasNext()) {
                EnterpriseResourceData enterpriseResourceData;
                Object e = iterator.next();
                enterpriseResourceData = (EnterpriseResourceData)((Object)node.next());
                resource = (Resource)hashMap2.get((Object)enterpriseResourceData);
                hashMap.put(e, resource);
            }
            resourcePool.setMaster(false);
            resourcePool.updateOutlineTypes();
            this.project.setAccessControlPolicy(resourceMappingForm.getAccessControlType());
            this.project.resetRoles(resourceMappingForm.getAccessControlType() == 0);
        }
        return true;
    }

    private void importOptions() {
        ProjectHeader projectHeader = this.mpx.getProjectHeader();
        MPXConverter.toProjityOptions(projectHeader, this.context);
    }

    private void importProjectFields() {
        ProjectHeader projectHeader = this.mpx.getProjectHeader();
        MPXConverter.toProjityProject(projectHeader, this.project, this.context);
        Date date = null;
        if (date != null) {
            this.project.setStart(DateTime.gmt(date));
        } else {
            this.project.setStart(this.earliestStart.getTime());
        }
    }

    private void importTasks() {
        this.allTasks = this.mpx.getAllTasks();
        for (Task task : this.allTasks) {
            if (task.getNull()) {
                System.out.println("skipping null task" + task.getName() + " " + task.getID());
                continue;
            }
            if (task.getSubProject() != null) {
                this.subprojects.add(task.getName());
            }
            if (task.getOutlineNumber() != null && task.getOutlineLevel() == 0) {
                if (this.dummyFirstTask != null) {
                    log.warn("Encountered more than one dummy first tasks");
                }
                this.dummyFirstTask = task;
                this.project.setName(task.getName());
                this.taskMap.put(task, null);
                continue;
            }
            NormalTask normalTask = this.project.newNormalTaskInstance(false);
            normalTask.setOwningProject(this.project);
            normalTask.setProjectId(this.project.getUniqueId());
            this.taskMap.put(task, normalTask);
            MPXConverter.toProjityTask(task, normalTask, this.context);
            Date date = DateTime.gmtDate((Date)task.getStart());
            this.earliestStart = this.earliestStart == null ? date : DateTime.min((Date)this.earliestStart, (Date)date);
        }
        if (!this.subprojects.isEmpty()) {
            Alert.warn((Object)(Messages.getString((String)"MicrosoftImporter.ImportWithSubprojects") + StringList.list((Collection)this.subprojects)));
        }
    }

    public void importDependencies() throws Exception {
        Iterator iterator = this.allTasks.iterator();
        CalendarOption calendarOption = CalendarOption.getInstance();
        CalendarOption.setInstance((CalendarOption)CalendarOption.getDefaultInstance());
        while (iterator.hasNext()) {
            List list;
            Task task = (Task)iterator.next();
            if (task == this.dummyFirstTask) continue;
            if (task == null) {
                System.out.println("null task");
            }
            if ((list = task.getPredecessors()) == null) continue;
            for (Relation relation : list) {
                this.addDependency(task, relation);
            }
        }
        CalendarOption.setInstance((CalendarOption)calendarOption);
    }

    private Dependency addDependency(Task task, Relation relation) {
        Dependency dependency;
        com.projity.pm.task.Task task2 = (com.projity.pm.task.Task)this.taskMap.get(this.mpx.getTaskByUniqueID(relation.getTaskUniqueID()));
        com.projity.pm.task.Task task3 = (com.projity.pm.task.Task)this.taskMap.get(task);
        if (task2 == null || task3 == null) {
            System.out.println("invalid dependency -pred task not found - maybe duplicate task UIDs pred UID=" + relation.getTaskUniqueID());
            return null;
        }
        try {
            dependency = DependencyService.getInstance().newDependency((HasDependencies)task2, (HasDependencies)task3, relation.getType().getType(), MPXConverter.toProjityDuration(relation.getDuration(), this.context), null);
        }
        catch (InvalidAssociationException invalidAssociationException) {
            log.error("Error adding dependency:" + invalidAssociationException.getMessage());
            dependency = null;
        }
        return dependency;
    }

    private void importHierarchy() {
        List list = this.mpx.getChildTasks();
        Iterator iterator = list.iterator();
        Task task = null;
        while (iterator.hasNext()) {
            task = (Task)iterator.next();
            this.importHierarchy(task, null);
        }
        this.insertTaskVoids();
    }

    private void importHierarchy(Task task, Node node) {
        Node node2 = null;
        com.projity.pm.task.Task task2 = (com.projity.pm.task.Task)this.taskMap.get(task);
        if (task2 != null) {
            node2 = NodeFactory.getInstance().createNode((Object)task2);
            this.project.addToDefaultOutline(node, node2);
        }
        List list = task.getChildTasks();
        for (Task task3 : list) {
            this.importHierarchy(task3, node2);
        }
    }

    private void insertTaskVoids() {
        long l = 0L;
        Iterator iterator = this.allTasks.iterator();
        NodeModel nodeModel = this.project.getTaskOutline();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task.getNull()) continue;
            int n = task.getID();
            int n2 = (int)((long)n - l - 1L);
            l = n;
            if (n2 == 0) continue;
            Object v = this.taskMap.get(task);
            Node node = nodeModel.search(v);
            for (int i = 0; i < n2; ++i) {
                Node node2 = NodeFactory.getInstance().createVoidNode();
                nodeModel.addBefore(node, node2, 0);
            }
        }
    }

    private void insertResourceVoids() {
        long l = 0L;
        Iterator iterator = this.mpx.getAllResources().iterator();
        NodeModel nodeModel = this.project.getResourcePool().getResourceOutline();
        while (iterator.hasNext()) {
            net.sf.mpxj.Resource resource = (net.sf.mpxj.Resource)iterator.next();
            if (resource.getNull() || resource.getID() == null) continue;
            int n = resource.getID();
            int n2 = (int)((long)n - l - 1L);
            l = n;
            if (n2 == 0) continue;
            Object v = this.resourceMap.get(resource);
            Node node = nodeModel.search(v);
            for (int i = 0; i < n2; ++i) {
                Node node2 = NodeFactory.getInstance().createVoidNode();
                nodeModel.addBefore(node, node2, 0);
            }
        }
    }

    private void importAssignments() {
        List list = this.mpx.getAllResourceAssignments();
        for (ResourceAssignment resourceAssignment : list) {
            this.addAssignment(resourceAssignment);
        }
    }

    private Assignment addAssignment(ResourceAssignment resourceAssignment) {
        WorkContour workContour;
        NormalTask normalTask = (NormalTask)this.taskMap.get(resourceAssignment.getTask());
        if (normalTask == null) {
            System.out.println("null task in assignment - dummy is " + (resourceAssignment.getTask() == this.dummyFirstTask));
            return null;
        }
        Resource resource = resourceAssignment.getResourceUniqueID() == -65535 ? ResourceImpl.getUnassignedInstance() : (Resource)this.resourceMap.get(resourceAssignment.getResource());
        if (resource == null) {
            System.out.println("null resource in assignment - ignored. resource id was " + resourceAssignment.getResourceUniqueID());
            return null;
        }
        Assignment assignment = AssignmentService.getInstance().newAssignment(normalTask, resource, resourceAssignment.getUnits().doubleValue() / 100.0, 0L, null);
        assignment.setStart(DateTime.gmt((Date)resourceAssignment.getStart()));
        if (resourceAssignment.getFinish() != null) {
            assignment.setEnd(DateTime.gmt((Date)resourceAssignment.getFinish()));
        }
        if ((workContour = resourceAssignment.getWorkContour()) == null) {
            assignment.setWorkContourType(0);
        } else if (workContour.getValue() == 8) {
            assignment.makeContourPersonal();
        } else {
            assignment.setWorkContourType(workContour.getValue());
        }
        List list = this.getTimephasedList(resourceAssignment);
        if (list != null) {
            ModifiedMSPDIReader.readAssignmentBaselinesAndTimephased(assignment, list);
        }
        return assignment;
    }

    private List getTimephasedList(ResourceAssignment resourceAssignment) {
        if (!this.context.isXml()) {
            return null;
        }
        return ((ModifiedMSPDIReader)this.reader).getTimephasedList(resourceAssignment);
    }

    public Job getExportFileJob() {
        LocalSession localSession = SessionFactory.getInstance().getLocalSession();
        Job job = new Job(localSession.getJobQueue(), "exportFile", "Exporting...", true);
        job.addRunnable(new JobRunnable("Local: export", 1.0f){

            public Object run() throws Exception {
                MSPDISerializer mSPDISerializer = new MSPDISerializer();
                mSPDISerializer.setJob(this);
                mSPDISerializer.saveProject(MicrosoftImporter.this.project, MicrosoftImporter.this.fileName);
                return null;
            }
        });
        return job;
    }
}

