/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.task;

import com.projity.document.Document;
import com.projity.document.ObjectEvent;
import com.projity.document.ObjectEventManager;
import com.projity.document.ObjectSelectionEventManager;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.grouping.core.model.NodeModelFactory;
import com.projity.grouping.core.summaries.DeepChildSearcher;
import com.projity.job.Job;
import com.projity.job.JobRunnable;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.task.Project;
import com.projity.pm.task.ProjectFactory;
import com.projity.session.SessionFactory;
import com.projity.strings.Messages;
import com.projity.undo.DataFactoryUndoController;
import com.projity.util.Alert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

public class Portfolio
implements Document,
NodeModelDataFactory {
    NodeModel nodeModel;
    ObjectEventManager objectEventManager;
    boolean creating = false;
    private transient boolean dirty;
    ProjectFactory projectFactory = null;
    public static ImplComparator comparator = new ImplComparator();

    public Portfolio(ProjectFactory projectFactory) {
        this.projectFactory = projectFactory;
        this.objectEventManager = new ObjectEventManager();
        this.nodeModel = NodeModelFactory.getInstance().createNodeModel(this);
        this.nodeModel.getHierarchy().setNbEndVoidNodes(0);
    }

    public Project findByUniqueId(long l2) {
        return (Project)DeepChildSearcher.searchForUniqueId(this.nodeModel, l2);
    }

    public boolean isResourcePoolOpenAndWritable() {
        Project project = (Project)DeepChildSearcher.search(this.nodeModel, new ResourcePoolFinder());
        return project != null;
    }

    void addProject(final Project project, boolean bl, boolean bl2) {
        if (!bl2) {
            this._addProject(project);
            return;
        }
        Job job = null;
        if (this.creating) {
            return;
        }
        Node node = this.nodeModel.search(project, comparator);
        if (node != null) {
            if (Alert.confirm(Messages.getString("Message.projectAlreadyExists")) == 1) {
                return;
            }
            job = this.getRemoveProjectJob((Project)node.getImpl(), true);
            if (job != null && !bl) {
                SessionFactory.getInstance().getSession(project.isLocal()).schedule(job);
            }
        }
        if (!bl) {
            this._addProject(project);
            return;
        }
        Job job2 = new Job(SessionFactory.getInstance().getSession(project.isLocal()).getJobQueue(), "addProject", "Adding project...", false);
        job2.addSwingRunnable(new JobRunnable("Local: addProject", 1.0f){

            public Object run() throws Exception {
                Portfolio.this._addProject(project);
                this.setProgress(1.0f);
                return null;
            }
        });
        if (job == null) {
            job = job2;
        } else {
            job.addJob(job2);
        }
        SessionFactory.getInstance().getSession(project.isLocal()).schedule(job);
    }

    private void _addProject(Project project) {
        this.nodeModel.add(NodeFactory.getInstance().createNode(project), 0);
        this.handleExternalTasks(project, true, false);
        this.objectEventManager.fireCreateEvent(this, project);
        project.getResourcePool().addProject(project);
    }

    void handleExternalTasks(final Project project, final boolean bl, final boolean bl2) {
        this.forProjects(new Closure(){

            public void execute(Object object) {
                Project project2 = (Project)object;
                if (project2 != project) {
                    project2.handleExternalTasks(project, bl, bl2);
                }
            }
        });
    }

    public void addSubproject(Project project, Project project2, Project project3) {
        Node node = this.nodeModel.search(project);
        boolean bl = false;
        if (node == null) {
            this.addProject(project, false, true);
            node = this.nodeModel.search(project);
        } else {
            bl = true;
            this.objectEventManager.fireCreateEvent(this, project);
        }
        Node node2 = this.nodeModel.search(project3);
        this.nodeModel.getHierarchy().move(node, node2, 0);
        this.objectEventManager.fireCreateEvent(this, project);
    }

    public Job getRemoveProjectJob(Project project, boolean bl) {
        return this.projectFactory.getRemoveProjectJob(project, true, true, bl);
    }

    public Job getRemoveAllProjectsJob(JobRunnable jobRunnable, boolean bl, boolean[] blArray) {
        Object object;
        boolean bl2 = true;
        if (blArray != null && blArray.length > 0) {
            blArray[0] = true;
        }
        Job job = new Job(SessionFactory.getInstance().getLocalSession().getJobQueue(), "removeAllProjects", "Removing projects...", true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = this.nodeModel.iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            if (object.isRoot()) continue;
            arrayList.add(object);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            object2 = (Project)((Node)object.next()).getImpl();
            if (((Project)object2).isOpenedAsSubproject()) continue;
            Job job2 = this.getRemoveProjectJob((Project)object2, bl);
            if (job2 == null) {
                if (bl) {
                    bl2 = false;
                }
                if (blArray == null || blArray.length <= 0) continue;
                System.out.println("Close cancelled");
                blArray[0] = false;
                continue;
            }
            job.addJob(job2);
        }
        if (bl2) {
            job.addRunnable(jobRunnable, !bl, false, bl, false);
        }
        return job;
    }

    public void addObjectListener(ObjectEvent.Listener listener) {
        this.objectEventManager.addListener(listener);
    }

    public void removeObjectListener(ObjectEvent.Listener listener) {
        this.objectEventManager.removeListener(listener);
    }

    public ObjectEventManager getObjectEventManager() {
        return this.objectEventManager;
    }

    public Object createUnvalidatedObject(NodeModel nodeModel, Object object) {
        this.creating = true;
        Project project = this.projectFactory.createProject();
        this.creating = false;
        return project;
    }

    public void addUnvalidatedObject(Object object, NodeModel nodeModel, Object object2) {
    }

    public void validateObject(Object object, NodeModel nodeModel, Object object2, Object object3, boolean bl) {
    }

    public void remove(Object object, NodeModel nodeModel, boolean bl, boolean bl2, boolean bl3) {
    }

    public NodeModel getNodeModel() {
        return this.nodeModel;
    }

    public void forProjects(Closure closure) {
        Iterator iterator = this.getNodeModel().iterator();
        while (iterator.hasNext()) {
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof Project)) continue;
            closure.execute(object);
        }
    }

    public Collection getDirtyProjectList() {
        final ArrayList arrayList = new ArrayList();
        this.forProjects(new Closure(){

            public void execute(Object object) {
                if (((Project)object).needsSaving()) {
                    arrayList.add(object);
                }
            }
        });
        return arrayList;
    }

    public Collection getWritableProjectList() {
        final ArrayList arrayList = new ArrayList();
        this.forProjects(new Closure(){

            public void execute(Object object) {
                if (!((Project)object).isReadOnly()) {
                    arrayList.add(object);
                }
            }
        });
        return arrayList;
    }

    public void fireUpdateEvent(Object object, Object object2) {
        this.objectEventManager.fireUpdateEvent(object, object2);
    }

    public int fireMultipleTransaction(int n2, boolean bl) {
        return 0;
    }

    public WorkCalendar getDefaultCalendar() {
        return null;
    }

    public final boolean isGroupDirty() {
        return this.dirty;
    }

    public final void setGroupDirty(boolean bl) {
        this.dirty = bl;
    }

    public ArrayList extractCalendars() {
        return WorkingCalendar.extractCalendars(this.nodeModel.getHierarchy());
    }

    public DataFactoryUndoController getUndoController() {
        return null;
    }

    public void rollbackUnvalidated(NodeModel nodeModel, Object object) {
    }

    public void initOutline(NodeModel nodeModel) {
    }

    public NodeModelDataFactory getFactoryToUseForChildOfParent(Object object) {
        return this;
    }

    public void setAllChildrenDirty(boolean bl) {
    }

    public boolean containsAssignments() {
        return false;
    }

    public boolean evaluate(Object object) {
        return false;
    }

    public ObjectSelectionEventManager getObjectSelectionEventManager() {
        return null;
    }

    public static class ImplComparator
    implements Comparator {
        ImplComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                return object2 == null ? 0 : 1;
            }
            if (((Node)object).getImpl().equals(object2)) {
                return 0;
            }
            return 1;
        }
    }

    private class ResourcePoolFinder
    implements Predicate {
        private ResourcePoolFinder() {
        }

        public boolean evaluate(Object object) {
            Project project = (Project)object;
            return project.isMaster() && !project.isReadOnly();
        }
    }
}

