/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.scheduling;

import com.projity.configuration.Configuration;
import com.projity.field.Field;
import com.projity.functor.IntervalConsumer;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.scheduling.ScheduleInterval;
import com.projity.undo.FieldEdit;
import com.projity.undo.ScheduleEdit;
import com.projity.undo.SplitEdit;
import com.projity.util.ClassUtils;
import com.projity.util.DateTime;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class ScheduleService {
    private boolean consuming = false;
    private static Field completedFieldInstance = null;
    private static ScheduleService instance = null;

    public static Field getCompletedField() {
        if (completedFieldInstance == null) {
            completedFieldInstance = Configuration.getFieldFromId("Field.stop");
        }
        return completedFieldInstance;
    }

    public static ScheduleService getInstance() {
        if (instance == null) {
            instance = new ScheduleService();
        }
        return instance;
    }

    private ScheduleService() {
    }

    public long getCompleted(Schedule schedule) {
        return schedule.getCompletedThrough();
    }

    public void setCompleted(Object object, Schedule schedule, long l2, UndoableEditSupport undoableEditSupport) {
        if (ScheduleService.isReadOnly(schedule)) {
            return;
        }
        Field field = ScheduleService.getCompletedField();
        Object object2 = field.getValue(schedule);
        if (object2 == null) {
            object2 = new Long(schedule.getActualStart());
        }
        Long l3 = new Long(l2);
        field.setValue(schedule, object, l3);
        if (undoableEditSupport != null && !(object instanceof UndoableEdit)) {
            undoableEditSupport.postEdit(new FieldEdit(field, schedule, l3, object2, object, null));
        }
    }

    public static boolean isReadOnly(Schedule schedule) {
        return ClassUtils.isObjectReadOnly(schedule);
    }

    public void setInterval(Object object, Schedule schedule, long l2, long l3, ScheduleInterval scheduleInterval, UndoableEditSupport undoableEditSupport) {
        if (ScheduleService.isReadOnly(schedule)) {
            return;
        }
        Object object2 = null;
        l2 = DateTime.hourFloor(l2);
        l3 = DateTime.hourFloor(l3);
        if (scheduleInterval.getStart() == l2 && scheduleInterval.getEnd() == l3) {
            return;
        }
        if (undoableEditSupport != null && !(object instanceof UndoableEdit)) {
            object2 = schedule.backupDetail();
        }
        schedule.moveInterval(object, l2, l3, scheduleInterval, false);
        if (object2 != null) {
            undoableEditSupport.postEdit(new ScheduleEdit(schedule, object2, l2, l3, scheduleInterval, false, object));
        }
    }

    public void split(Object object, Schedule schedule, long l2, long l3, UndoableEditSupport undoableEditSupport) {
        if (ScheduleService.isReadOnly(schedule)) {
            return;
        }
        Object object2 = null;
        if (undoableEditSupport != null && !(object instanceof UndoableEdit)) {
            object2 = schedule.backupDetail();
        }
        schedule.split(object, DateTime.hourFloor(l2), DateTime.hourFloor(l3));
        if (object2 != null) {
            undoableEditSupport.postEdit(new SplitEdit(schedule, object2, l2, l3, object));
        }
    }

    public void consumeIntervals(Schedule schedule, IntervalConsumer intervalConsumer) {
        if (this.consuming) {
            return;
        }
        this.consuming = true;
        schedule.consumeIntervals(intervalConsumer);
        this.consuming = false;
    }
}

