/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.scheduling;

import com.projity.datatype.Duration;
import com.projity.pm.assignment.Allocation;
import com.projity.pm.scheduling.SchedulingRule;
import com.projity.strings.Messages;

public class FixedUnits
implements SchedulingRule {
    private static FixedUnits instance = null;

    public String toString() {
        return Messages.getString("FixedUnits.FixedUnits");
    }

    public void adjustRemainingUnits(Allocation allocation, double d2, double d3, boolean bl, boolean bl2) {
        if (d2 == 0.0) {
            allocation.adjustRemainingDuration(0L, bl);
            allocation.adjustRemainingUnits(1.0, d3, bl, false);
        } else if (d3 == 0.0) {
            allocation.adjustRemainingUnits(1.0, d3, false, false);
        } else {
            allocation.adjustRemainingWork(d3 / d2, bl);
        }
    }

    public void adjustRemainingDuration(Allocation allocation, long l2, boolean bl) {
        allocation.adjustRemainingDuration(l2, bl);
    }

    public void adjustRemainingWork(Allocation allocation, long l2, boolean bl) {
        long l3 = allocation.getRemainingWork();
        this.adjustRemainingWork(allocation, l2, l3, bl);
    }

    public void adjustRemainingWork(Allocation allocation, long l2, long l3, boolean bl) {
        long l4;
        if (l3 == 0L) {
            l4 = (long)((double)l2 / allocation.getRemainingUnits());
        } else {
            l2 = Duration.millis(l2);
            l4 = (long)((double)allocation.getRemainingDuration() * (double)l2 / (double)l3);
        }
        allocation.adjustRemainingDuration(l4, bl);
    }

    private FixedUnits() {
    }

    public static FixedUnits getInstance() {
        if (instance == null) {
            instance = new FixedUnits();
        }
        return instance;
    }
}

