/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.timescale;

import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.spreadsheet.common.GradientCorner;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.timescale.ScaledComponent;
import com.projity.pm.graphic.timescale.TimeScaleComponent;
import com.projity.timescale.TimeScaleEvent;
import com.projity.timescale.TimeScaleListener;
import com.projity.workspace.SavableToWorkspace;
import com.projity.workspace.WorkspaceSetting;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScaledScrollPane
extends JScrollPane
implements TimeScaleListener,
SavableToWorkspace {
    private static final long serialVersionUID = -6608484720122760191L;
    protected TimeScaleComponent timeScaleComponent;
    protected CoordinatesConverter coord;
    protected ScaledComponent main;
    protected DocumentFrame documentFrame;
    private Dimension olddmain = null;
    protected JComponent emptyRowHeader = null;

    public ScaledScrollPane(ScaledComponent scaledComponent, CoordinatesConverter coordinatesConverter, DocumentFrame documentFrame, int n2) {
        super((JComponent)((Object)scaledComponent), 22, 32);
        this.main = scaledComponent;
        this.coord = coordinatesConverter;
        this.documentFrame = documentFrame;
        scaledComponent.setCoord(coordinatesConverter);
        this.createLayout();
        coordinatesConverter.addTimeScaleListener(this);
        this.getVerticalScrollBar().setUnitIncrement(n2);
        this.getHorizontalScrollBar().setUnitIncrement(coordinatesConverter.getTimescaleManager().getMinWidth());
    }

    public void createLayout() {
        this.setPreferredSize(new Dimension(300, 250));
        this.timeScaleComponent = new TimeScaleComponent(this.coord);
        this.setColumnHeaderView(this.timeScaleComponent);
        this.getViewport().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ScaledScrollPane.this.updateTimeScaleComponentSize();
            }
        });
        this.setCorner("UPPER_RIGHT_CORNER", new GradientCorner());
    }

    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
        this.timeScaleComponent.repaint();
        this.getHorizontalScrollBar().setUnitIncrement(this.coord.getTimescaleManager().getMinWidth());
    }

    public void updateTimeScaleComponentSize() {
        Dimension dimension = this.getViewport().getViewSize();
        if (dimension.equals(this.olddmain)) {
            return;
        }
        this.olddmain = dimension;
        this.timeScaleComponent.setPreferredSize(new Dimension(dimension.width, this.timeScaleComponent.getPreferredSize().height));
        this.getColumnHeader().setViewSize(new Dimension(dimension.width, this.getColumnHeader().getViewSize().height));
    }

    public Component getTimeScaleComponent() {
        return this.timeScaleComponent;
    }

    public void activateEmptyRowHeader(boolean bl) {
        if (bl) {
            this.activateEmptyRowHeader();
        } else {
            this.deactivateEmptyRowHeader();
        }
    }

    public void activateEmptyRowHeader() {
        if (this.emptyRowHeader == null) {
            int n2 = 40;
            this.emptyRowHeader = new JPanel();
            this.emptyRowHeader.setBackground(this.getViewport().getView().getBackground());
            this.emptyRowHeader.setPreferredSize(new Dimension(n2, (int)this.getViewport().getViewSize().getHeight()));
            JViewport jViewport = new JViewport();
            jViewport.setView(this.emptyRowHeader);
            jViewport.setPreferredSize(this.emptyRowHeader.getPreferredSize());
            this.setRowHeader(jViewport);
        }
    }

    public void deactivateEmptyRowHeader() {
        if (this.emptyRowHeader != null) {
            this.getRowHeader().remove(this.emptyRowHeader);
            this.remove(this.getRowHeader());
            this.emptyRowHeader = null;
        }
    }

    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n2) {
        Workspace workspace = (Workspace)workspaceSetting;
        if (workspace.viewPosition != null) {
            this.getViewport().setViewPosition(workspace.viewPosition);
        }
    }

    public WorkspaceSetting createWorkspace(int n2) {
        Workspace workspace = new Workspace();
        workspace.viewPosition = this.getViewport().getViewPosition();
        return workspace;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = 8372367946057729222L;
        Point viewPosition = null;

        public Point getViewPosition() {
            return this.viewPosition;
        }

        public void setViewPosition(Point point) {
            this.viewPosition = point;
        }
    }
}

