/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.time;

import com.projity.pm.graphic.spreadsheet.time.TimeSpreadSheet;
import com.projity.pm.graphic.spreadsheet.time.TimeSpreadSheetModel;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.timescale.TimeInterval;
import com.projity.timescale.TimeIterator;
import com.projity.timescale.TimeScaleEvent;
import com.projity.timescale.TimeScaleListener;
import java.awt.Dimension;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class TimeSpreadSheetColumnModel
extends DefaultTableColumnModel
implements TimeScaleListener {
    protected CoordinatesConverter coord;
    protected TimeSpreadSheet spreadSheet;

    public TimeSpreadSheetColumnModel(TimeSpreadSheet timeSpreadSheet) {
        this.spreadSheet = timeSpreadSheet;
    }

    public void updateColumns() {
        while (this.getColumnCount() > 0) {
            this.removeColumn(this.getColumn(0));
            ((TimeSpreadSheetModel)this.spreadSheet.getModel()).decrementColumnCount();
        }
        if (this.coord == null) {
            return;
        }
        TimeSpreadSheetModel timeSpreadSheetModel = (TimeSpreadSheetModel)this.spreadSheet.getModel();
        TimeIterator timeIterator = this.coord.getProjectTimeIterator();
        timeSpreadSheetModel.resetTimeIntervals();
        int n2 = 1;
        while (timeIterator.hasNext()) {
            TimeInterval timeInterval = timeIterator.next();
            int n3 = (int)Math.round(this.coord.toW(timeInterval.getEnd1() - timeInterval.getStart1()));
            TableColumn tableColumn = new TableColumn(n2, n3);
            tableColumn.setMinWidth(n3);
            tableColumn.setMaxWidth(n3);
            this.addColumn(tableColumn);
            timeSpreadSheetModel.incrementColumnCount();
            timeSpreadSheetModel.addTimeInterval(timeInterval);
            ++n2;
        }
    }

    public CoordinatesConverter getCoord() {
        return this.coord;
    }

    public void setCoord(CoordinatesConverter coordinatesConverter) {
        if (this.coord != null) {
            this.coord.removeTimeScaleListener(this);
        }
        this.coord = coordinatesConverter;
        coordinatesConverter.addTimeScaleListener(this);
    }

    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
        this.updateColumns();
        this.spreadSheet.setPreferredSize(new Dimension((int)this.coord.toW(this.coord.getEnd() - this.coord.getOrigin()), this.spreadSheet.getPreferredSize().height));
        this.spreadSheet.revalidate();
    }
}

