/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.frames;

import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.frames.workspace.FrameHolder;
import com.projity.pm.graphic.frames.workspace.FrameManager;
import com.projity.util.Environment;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class MainFrame
extends JFrame
implements FrameHolder {
    private static final long serialVersionUID = -5161903673269959353L;
    protected GraphicManager graphicManager;
    private static MainFrame instance = null;

    public MainFrame(String string, String string2, String string3) throws HeadlessException {
        super(string);
        instance = this;
        this.setIconImage(IconManager.getImage("application.icon"));
        this.init();
    }

    public GraphicManager getGraphicManager() {
        return this.graphicManager;
    }

    public void init() {
        if (Environment.isWindows()) {
            this.setSize(1024, 768);
        }
        if (Environment.isMac()) {
            this.setPreferredSize(new Dimension(1280, 768));
        } else {
            this.setPreferredSize(new Dimension(1024, 768));
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.graphicManager.closeApplication();
            }
        });
    }

    public void setGraphicManager(GraphicManager graphicManager) {
        this.graphicManager = graphicManager;
    }

    public FrameManager getFrameManager() {
        return this.graphicManager.getFrameManager();
    }

    public static MainFrame getInstance() {
        return instance;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }
}

