/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.contour;

import com.projity.algorithm.IntervalGenerator;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import com.projity.pm.assignment.contour.FillerContourBucket;
import com.projity.pm.assignment.contour.PersonalContourBucket;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.task.Project;

public class ContourBucketIntervalGenerator
implements IntervalGenerator {
    protected final int BEFORE_START = -1;
    protected final int AFTER_END = -2;
    protected long consumedDuration = 0L;
    protected int index = -1;
    long durationLeftUntilRemainingStartDependency = Long.MAX_VALUE;
    long start = 0L;
    long end;
    long assignmentDuration;
    long assignmentActualDuration = 0L;
    private AbstractContourBucket[] contourBuckets = null;
    WorkCalendar workCalendar;
    long splitAtDuration = Long.MAX_VALUE;
    long splitDuration = 0L;
    long remainingSplitBucketDuration = 0L;
    AbstractContourBucket specialBucket = null;
    boolean didSplit = false;
    boolean didFirstPart = false;

    public static ContourBucketIntervalGenerator getInstance(Assignment assignment, Object object) {
        return new ContourBucketIntervalGenerator(assignment, object);
    }

    protected ContourBucketIntervalGenerator(Assignment assignment, Object object) {
        long l2;
        this.workCalendar = assignment.getEffectiveWorkCalendar();
        this.contourBuckets = assignment.getContour(object);
        this.assignmentDuration = assignment.getDurationMillis();
        this.assignmentActualDuration = assignment.getActualDuration();
        this.end = l2 = assignment.getStart();
        Project project = assignment.getTask().getProject();
        if (project != null && !project.isForward()) {
            return;
        }
        if (assignment.getDependencyStart() > l2 && assignment.getPercentComplete() > 0.0) {
            this.durationLeftUntilRemainingStartDependency = this.workCalendar.compare(assignment.getDependencyStart(), l2, false);
            if (this.durationLeftUntilRemainingStartDependency > 0L && this.durationLeftUntilRemainingStartDependency > this.assignmentActualDuration) {
                this.splitAtDuration = this.assignmentActualDuration;
                this.splitDuration = this.durationLeftUntilRemainingStartDependency - this.assignmentActualDuration;
            }
        }
    }

    public long currentEnd() {
        return this.end;
    }

    public long currentStart() {
        return this.start;
    }

    public Object current() {
        AbstractContourBucket abstractContourBucket = null;
        if (this.specialBucket != null) {
            abstractContourBucket = this.specialBucket;
        } else if (this.index >= 0) {
            abstractContourBucket = this.contourBuckets[this.index];
        }
        return abstractContourBucket;
    }

    public boolean hasNext() {
        return this.index < this.contourBuckets.length - 1;
    }

    public boolean evaluate(Object object) {
        ++this.index;
        if (this.index == this.contourBuckets.length) {
            return false;
        }
        this.start = this.workCalendar.add(this.end, 0L, false);
        this.specialBucket = null;
        long l2 = this.contourBuckets[this.index].getBucketDuration(this.assignmentDuration);
        this.consumedDuration += l2;
        if (this.consumedDuration >= this.splitAtDuration) {
            this.remainingSplitBucketDuration = this.consumedDuration - this.splitAtDuration;
            if ((l2 -= this.remainingSplitBucketDuration) > 0L) {
                this.specialBucket = PersonalContourBucket.getInstance(l2, this.contourBuckets[this.index].getUnits());
                --this.index;
            }
            this.splitAtDuration = Long.MAX_VALUE;
            this.didFirstPart = true;
        }
        if (this.specialBucket == null && this.didFirstPart) {
            if (!this.didSplit) {
                l2 = this.splitDuration;
                this.specialBucket = FillerContourBucket.getInstance(this.splitDuration);
                --this.index;
                this.didSplit = true;
            } else {
                l2 = this.remainingSplitBucketDuration;
                double d2 = this.contourBuckets[this.index].getUnits();
                if (l2 > 0L) {
                    this.specialBucket = PersonalContourBucket.getInstance(this.remainingSplitBucketDuration, d2);
                }
                this.remainingSplitBucketDuration = 0L;
                this.didFirstPart = false;
            }
        }
        this.end = this.workCalendar.add(this.end, l2, true);
        return true;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public boolean isCurrentActive() {
        AbstractContourBucket abstractContourBucket = (AbstractContourBucket)this.current();
        return abstractContourBucket != null && abstractContourBucket.getUnits() != 0.0;
    }

    public WorkCalendar getWorkCalendar() {
        return this.workCalendar;
    }

    public boolean canBeShared() {
        return false;
    }
}

