/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core;

import com.projity.grouping.core.GroupNodeImpl;
import com.projity.grouping.core.LazyParent;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeException;
import com.projity.grouping.core.NodeVisitor;
import com.projity.grouping.core.VoidNodeImpl;
import com.projity.grouping.core.model.NodeModelUtil;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.resource.Resource;
import com.projity.pm.task.Task;
import com.projity.server.data.DataObject;
import java.util.List;
import java.util.ListIterator;
import javax.swing.tree.DefaultMutableTreeNode;

public class NodeBridge
extends DefaultMutableTreeNode
implements Node {
    protected boolean virtual = false;
    protected boolean voidNode = false;
    protected boolean root = false;
    protected transient boolean lazyParent = false;
    protected int subprojectLevel;

    NodeBridge(Object object) {
        this.setImpl(object);
    }

    NodeBridge(Object object, boolean bl) {
        this(object);
        this.virtual = bl;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean bl) {
        this.virtual = bl;
    }

    public boolean isVoid() {
        return this.voidNode;
    }

    public void setVoid(boolean bl) {
        this.voidNode = bl;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean bl) {
        this.root = bl;
    }

    public Class getType() throws NodeException {
        Object object = this.getUserObject();
        if (object == null) {
            throw new NodeException("No Implementation");
        }
        return object.getClass();
    }

    public void accept(NodeVisitor nodeVisitor) {
        nodeVisitor.execute(this);
    }

    public String toString() {
        Object object = this.getUserObject();
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public Object getImpl() {
        return this.getUserObject();
    }

    public void setImpl(Object object) {
        this.virtual = object instanceof GroupNodeImpl;
        this.voidNode = object instanceof VoidNodeImpl;
        this.setUserObject(object);
    }

    static ListIterator emptyListIterator() {
        return new ListIterator(){

            public boolean hasNext() {
                return false;
            }

            public Object next() {
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void add(Object object) {
            }

            public boolean hasPrevious() {
                return false;
            }

            public int nextIndex() {
                return 0;
            }

            public Object previous() {
                return null;
            }

            public int previousIndex() {
                return -1;
            }

            public void set(Object object) {
            }
        };
    }

    public ListIterator childrenIterator() {
        return this.children == null ? NodeBridge.emptyListIterator() : this.children.listIterator();
    }

    public ListIterator childrenIterator(int n2) {
        return this.children == null ? NodeBridge.emptyListIterator() : this.children.listIterator(n2);
    }

    public List getChildren() {
        return this.children;
    }

    public boolean isIndentable(int n2) {
        if (n2 != 1 && n2 != -1) {
            return false;
        }
        return !this.root && !this.voidNode && !this.virtual && !(this.getImpl() instanceof Assignment);
    }

    public boolean canBeChildOf(Node node) {
        if (node.isVoid()) {
            return false;
        }
        return NodeModelUtil.canBeChildOf(node, this);
    }

    public boolean isDirty() {
        Object object = this.getImpl();
        if (object instanceof DataObject) {
            return ((DataObject)object).isDirty();
        }
        return false;
    }

    public void setDirty(boolean bl) {
        Object object = this.getImpl();
        if (object instanceof DataObject) {
            ((DataObject)object).setDirty(bl);
        }
    }

    public final boolean isLazyParent() {
        return this.getImpl() instanceof LazyParent;
    }

    public final boolean isValidLazyParent() {
        return this.getImpl() instanceof LazyParent && ((LazyParent)this.getImpl()).isValid();
    }

    public boolean hasNumber() {
        Object object = this.getImpl();
        return object instanceof Task || object instanceof Resource;
    }

    public int getSubprojectLevel() {
        return this.subprojectLevel;
    }

    public void setSubprojectLevel(int n2) {
        this.subprojectLevel = n2;
    }

    public boolean isInSubproject() {
        return this.getSubprojectLevel() > 0;
    }
}

