/*
 * Decompiled with CFR 0.152.
 */
package com.projity.graphic.configuration;

import com.projity.field.InvalidFormulaException;
import com.projity.graphic.configuration.CellStyle;
import com.projity.strings.Messages;
import groovy.lang.GroovyClassLoader;

public class CellStyleFactory {
    protected String formulaText;
    protected String formulaClass;
    protected String id = null;
    protected String name = null;
    protected String type = null;
    protected String format = null;
    private static int count = 0;

    public CellStyle getCellStyle() throws InvalidFormulaException {
        if (this.formulaClass != null) {
            try {
                return (CellStyle)Class.forName(this.formulaClass).newInstance();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            return null;
        }
        if (this.formulaText != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("package com.projity.graphic.configuration;\n");
            stringBuffer.append("import com.projity.pm.graphic.model.cache.GraphicNode;\n");
            stringBuffer.append("public class CellStyle").append(count++).append(" implements CellStyle{\n");
            stringBuffer.append("\tpublic CellFormat getCellFormat(Object _nodeObject){\n\t\tGraphicNode ").append(this.type).append("=(GraphicNode)_nodeObject;\n\t\tCellFormat ").append(this.format).append("=new CellFormat();\n").append(this.formulaText).append("\n\t\treturn ").append(this.format).append(";\n\t}\n");
            stringBuffer.append("}\n");
            GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
            try {
                Class clazz = groovyClassLoader.parseClass(stringBuffer.toString());
                CellStyle cellStyle = (CellStyle)clazz.newInstance();
                return cellStyle;
            }
            catch (Exception exception) {
                throw new InvalidFormulaException(exception);
            }
        }
        return null;
    }

    public String getFormulaText() {
        return this.formulaText;
    }

    public void setFormulaText(String string) {
        this.formulaText = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
        this.setName(Messages.getString(string));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getFormulaClass() {
        return this.formulaClass;
    }

    public void setFormulaClass(String string) {
        this.formulaClass = string;
    }
}

