/*
 * Decompiled with CFR 0.152.
 */
package com.projity.graphic.configuration;

import com.projity.configuration.Dictionary;
import com.projity.configuration.NamedItem;
import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.field.InvalidFormulaException;
import com.projity.graphic.configuration.ActionList;
import com.projity.graphic.configuration.ActionListFactory;
import com.projity.strings.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;

public class ActionLists
implements NamedItem {
    static Log log = LogFactory.getLog(ActionLists.class);
    public static final String category = "ActionListsCategory";
    String name = null;
    String id = null;
    Map actionListMap = new HashMap();
    Map factoryMap = new HashMap();
    List factories = new ArrayList();
    protected static ActionLists instance = null;

    public String getCategory() {
        return category;
    }

    public void addActionList(ActionListFactory actionListFactory) {
        this.factories.add(actionListFactory);
        this.factoryMap.put(actionListFactory.getId(), actionListFactory);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setId(String string) {
        this.id = string;
        this.setName(Messages.getString(string));
    }

    public String getId() {
        return this.id;
    }

    public ActionList getActionList(String string) {
        ActionList actionList = (ActionList)this.actionListMap.get(string);
        if (actionList == null) {
            ActionListFactory actionListFactory = this.getFactory(string);
            try {
                actionList = actionListFactory.getActionList();
                this.actionListMap.put(string, actionList);
            }
            catch (InvalidFormulaException invalidFormulaException) {
                log.error("Formula not set: invalid formula text: " + actionListFactory.getFormulaText());
            }
        }
        return actionList;
    }

    public ActionList getDefaultActionList() {
        return this.getActionList("ActionList.default");
    }

    public ActionListFactory getFactory(String string) {
        return (ActionListFactory)this.factoryMap.get(string);
    }

    public List getFactories() {
        return this.factories;
    }

    public static void addDigesterEvents(Digester digester) {
        digester.addObjectCreate("*/actionLists", "com.projity.graphic.configuration.ActionLists");
        digester.addSetProperties("*/actionLists");
        digester.addSetNext("*/actionLists", "add", "com.projity.configuration.NamedItem");
        digester.addObjectCreate("*/actionLists/actionList", "com.projity.graphic.configuration.ActionListFactory");
        digester.addSetProperties("*/actionLists/actionList");
        digester.addCallMethod("*/actionLists/actionList/formulaText", "setFormulaText", 0);
        digester.addSetNext("*/actionLists/actionList", "addActionList", "com.projity.graphic.configuration.ActionListFactory");
    }

    public static ActionLists getInstance() {
        if (instance == null) {
            instance = (ActionLists)Dictionary.get(category, "default");
        }
        return instance;
    }
}

