/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.LicenseDialog;
import com.projity.dialog.TipOfTheDay;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.strings.Messages;
import com.projity.util.BrowserControl;
import com.projity.util.Environment;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class HelpDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final String helpUrl = "http://www.projity.com/doc.html";
    private static final String videosUrl = "http://www.projity.com/demos.html";
    public static final String donateUrl = "https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=paypal%40projity%2ecom&item_name=OpenProj%20Donation&no_shipping=0&no_note=1&tax=0&currency_code=USD&lc=US&bn=PP%2dDonationsBF&charset=UTF%2d8";
    JButton link;
    JButton videos;
    JButton tipOfTheDay;
    JButton license;
    private JPanel donatePanel;

    public static HelpDialog getInstance(Frame frame) {
        return new HelpDialog(frame);
    }

    private HelpDialog(Frame frame) {
        super(frame, Messages.getString("HelpDialog.About") + " " + Messages.getContextString("Text.ApplicationTitle"), true);
    }

    protected void initComponents() {
        this.link = new JButton(Messages.getString("HelpDialog.GoToOnlineHelp"));
        this.link.setEnabled(true);
        this.link.setToolTipText(helpUrl);
        this.link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL(HelpDialog.helpUrl);
            }
        });
        if (Environment.isOpenProj()) {
            this.tipOfTheDay = new JButton(Messages.getString("HelpDialog.ShowTipsOfTheDay"));
            this.tipOfTheDay.setEnabled(true);
            this.tipOfTheDay.setToolTipText(Messages.getString("HelpDialog.ShowTipsOfTheDay"));
            this.tipOfTheDay.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TipOfTheDay.showDialog(HelpDialog.this.getOwner(), true);
                }
            });
        }
        this.license = new JButton(Messages.getString("HelpDialog.ShowLicense"));
        this.license.setEnabled(true);
        this.license.setToolTipText(Messages.getString("HelpDialog.ShowLicense"));
        this.license.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseDialog.showDialog(GraphicManager.getFrameInstance(), true);
            }
        });
        super.initComponents();
    }

    public JComponent createContentPanel() {
        FormLayout formLayout = new FormLayout("180px", "p, 6dlu,  p,6dlu,p,6dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel(IconManager.getIcon("icon.projity"));
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BrowserControl.displayURL("http://www.projity.com");
            }
        });
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.link);
        if (Environment.isOpenProj()) {
            defaultFormBuilder.nextLine(2);
            defaultFormBuilder.append(this.tipOfTheDay);
        }
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.license);
        if (Environment.isOpenProj()) {
            JPanel jPanel = new JPanel();
            jPanel.add(defaultFormBuilder.getPanel());
            return jPanel;
        }
        return defaultFormBuilder.getPanel();
    }

    protected boolean hasCloseButton() {
        return true;
    }

    protected boolean hasOkAndCancelButtons() {
        return false;
    }

    public static JPanel makeDonatePanel(boolean bl) {
        FormLayout formLayout = new FormLayout("250px", "p, 6dlu,  p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        if (bl) {
            defaultFormBuilder.setDefaultDialogBorder();
        }
        JLabel jLabel = new JLabel(Messages.getString("Text.donateMessage"));
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.nextLine(2);
        ImageIcon imageIcon = IconManager.getIcon("paypal.donate");
        JButton jButton = new JButton(imageIcon);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        defaultFormBuilder.append(jButton);
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL(HelpDialog.donateUrl);
            }
        });
        return defaultFormBuilder.getPanel();
    }
}

