/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.calendar;

import java.util.Date;

public class DateSpan {
    private long a;
    private long b;

    public DateSpan(long l2, long l3) {
        this.a = l2;
        this.b = l3;
        if (this.a > this.b) {
            throw new IllegalArgumentException("Start date must be before end date");
        }
    }

    public DateSpan(Date date, Date date2) {
        this(date.getTime(), date2.getTime());
    }

    public long getStart() {
        return this.a;
    }

    public long getEnd() {
        return this.b;
    }

    public Date getStartAsDate() {
        return new Date(this.getStart());
    }

    public Date getEndAsDate() {
        return new Date(this.getEnd());
    }

    public boolean contains(DateSpan dateSpan) {
        return this.contains(dateSpan.getStart()) && this.contains(dateSpan.getEnd());
    }

    public boolean contains(long l2) {
        return l2 >= this.getStart() && l2 <= this.getEnd();
    }

    public boolean contains(long l2, long l3) {
        return l2 >= this.getStart() && l3 <= this.getEnd();
    }

    public boolean intersects(long l2, long l3) {
        return l2 <= this.getEnd() && l3 >= this.getStart();
    }

    public boolean intersects(DateSpan dateSpan) {
        return this.intersects(dateSpan.getStart(), dateSpan.getEnd());
    }

    public DateSpan add(DateSpan dateSpan) {
        return this.add(dateSpan.getStart(), dateSpan.getEnd());
    }

    public DateSpan add(long l2, long l3) {
        return new DateSpan(Math.min(l2, this.getStart()), Math.max(l3, this.getEnd()));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DateSpan) {
            DateSpan dateSpan = (DateSpan)object;
            return this.a == dateSpan.getStart() && this.b == dateSpan.getEnd();
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        n2 = 629 + (int)(this.a ^ this.a >>> 32);
        n2 = 37 * n2 + (int)(this.b ^ this.b >>> 32);
        return n2;
    }

    public String toString() {
        return "DateSpan [" + this.getStartAsDate() + "-" + this.getEndAsDate() + "]";
    }
}

