/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.c;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.EmptyListIterator;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.a;
import org.apache.commons.collections.iterators.d;
import org.apache.commons.collections.iterators.e;
import org.apache.commons.collections.iterators.f;
import org.apache.commons.collections.iterators.h;
import org.apache.commons.collections.iterators.i;
import org.apache.commons.collections.iterators.k;
import org.apache.commons.collections.iterators.m;
import org.apache.commons.collections.iterators.n;
import org.apache.commons.collections.iterators.o;
import org.apache.commons.collections.iterators.p;
import org.apache.commons.collections.iterators.q;
import org.apache.commons.collections.iterators.s;
import org.apache.commons.collections.iterators.t;
import org.apache.commons.collections.iterators.u;
import org.apache.commons.collections.iterators.v;
import org.apache.commons.collections.iterators.x;
import org.apache.commons.collections.j;
import org.apache.commons.collections.r;
import org.apache.commons.collections.w;

public class IteratorUtils {
    public static final w EMPTY_ITERATOR = EmptyIterator.RESETTABLE_INSTANCE;
    public static final c EMPTY_LIST_ITERATOR = EmptyListIterator.RESETTABLE_INSTANCE;
    public static final r EMPTY_ORDERED_ITERATOR = u.a;
    public static final MapIterator EMPTY_MAP_ITERATOR = k.a;
    public static final j EMPTY_ORDERED_MAP_ITERATOR = org.apache.commons.collections.iterators.r.a;
    static Class a;

    public static w emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static c emptyListIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static r emptyOrderedIterator() {
        return EMPTY_ORDERED_ITERATOR;
    }

    public static MapIterator emptyMapIterator() {
        return EMPTY_MAP_ITERATOR;
    }

    public static j emptyOrderedMapIterator() {
        return EMPTY_ORDERED_MAP_ITERATOR;
    }

    public static w singletonIterator(Object object) {
        return new h(object);
    }

    public static ListIterator singletonListIterator(Object object) {
        return new d(object);
    }

    public static w arrayIterator(Object[] objectArray) {
        return new f(objectArray);
    }

    public static w arrayIterator(Object object) {
        return new q(object);
    }

    public static w arrayIterator(Object[] objectArray, int n2) {
        return new f(objectArray, n2);
    }

    public static w arrayIterator(Object object, int n2) {
        return new q(object, n2);
    }

    public static w arrayIterator(Object[] objectArray, int n2, int n3) {
        return new f(objectArray, n2, n3);
    }

    public static w arrayIterator(Object object, int n2, int n3) {
        return new q(object, n2, n3);
    }

    public static c arrayListIterator(Object[] objectArray) {
        return new s(objectArray);
    }

    public static c arrayListIterator(Object object) {
        return new org.apache.commons.collections.iterators.j(object);
    }

    public static c arrayListIterator(Object[] objectArray, int n2) {
        return new s(objectArray, n2);
    }

    public static c arrayListIterator(Object object, int n2) {
        return new org.apache.commons.collections.iterators.j(object, n2);
    }

    public static c arrayListIterator(Object[] objectArray, int n2, int n3) {
        return new s(objectArray, n2, n3);
    }

    public static c arrayListIterator(Object object, int n2, int n3) {
        return new org.apache.commons.collections.iterators.j(object, n2, n3);
    }

    public static Iterator unmodifiableIterator(Iterator iterator) {
        return i.a(iterator);
    }

    public static ListIterator unmodifiableListIterator(ListIterator listIterator) {
        return n.a(listIterator);
    }

    public static MapIterator unmodifiableMapIterator(MapIterator mapIterator) {
        return p.a(mapIterator);
    }

    public static Iterator chainedIterator(Iterator iterator, Iterator iterator2) {
        return new org.apache.commons.collections.iterators.c(iterator, iterator2);
    }

    public static Iterator chainedIterator(Iterator[] iteratorArray) {
        return new org.apache.commons.collections.iterators.c(iteratorArray);
    }

    public static Iterator chainedIterator(Collection collection) {
        return new org.apache.commons.collections.iterators.c(collection);
    }

    public static Iterator collatedIterator(Comparator comparator, Iterator iterator, Iterator iterator2) {
        return new t(comparator, iterator, iterator2);
    }

    public static Iterator collatedIterator(Comparator comparator, Iterator[] iteratorArray) {
        return new t(comparator, iteratorArray);
    }

    public static Iterator collatedIterator(Comparator comparator, Collection collection) {
        return new t(comparator, collection);
    }

    public static Iterator objectGraphIterator(Object object, Transformer transformer) {
        return new e(object, transformer);
    }

    public static Iterator transformedIterator(Iterator iterator, Transformer transformer) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (transformer == null) {
            throw new NullPointerException("Transformer must not be null");
        }
        return new org.apache.commons.collections.iterators.w(iterator, transformer);
    }

    public static Iterator filteredIterator(Iterator iterator, Predicate predicate) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new FilterIterator(iterator, predicate);
    }

    public static ListIterator filteredListIterator(ListIterator listIterator, Predicate predicate) {
        if (listIterator == null) {
            throw new NullPointerException("ListIterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new v(listIterator, predicate);
    }

    public static w loopingIterator(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        return new o(collection);
    }

    public static Iterator asIterator(Enumeration enumeration) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        return new a(enumeration);
    }

    public static Iterator asIterator(Enumeration enumeration, Collection collection) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        if (collection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        return new a(enumeration, collection);
    }

    public static Enumeration asEnumeration(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new x(iterator);
    }

    public static ListIterator toListIterator(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new m(iterator);
    }

    public static Object[] toArray(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        List list = IteratorUtils.toList(iterator, 100);
        return list.toArray();
    }

    public static Object[] toArray(Iterator iterator, Class clazz) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (clazz == null) {
            throw new NullPointerException("Array class must not be null");
        }
        List list = IteratorUtils.toList(iterator, 100);
        return list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    public static List toList(Iterator iterator) {
        return IteratorUtils.toList(iterator, 10);
    }

    public static List toList(Iterator iterator, int n2) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Estimated size must be greater than 0");
        }
        ArrayList arrayList = new ArrayList(n2);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static Iterator getIterator(Object object) {
        if (object == null) {
            return IteratorUtils.emptyIterator();
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof Object[]) {
            return new f((Object[])object);
        }
        if (object instanceof Enumeration) {
            return new a((Enumeration)object);
        }
        if (object instanceof Map) {
            return ((Map)object).values().iterator();
        }
        if (object instanceof Dictionary) {
            return new a(((Dictionary)object).elements());
        }
        if (object != null && object.getClass().isArray()) {
            return new q(object);
        }
        try {
            Iterator iterator;
            Method method = object.getClass().getMethod("iterator", null);
            if ((a == null ? (a = IteratorUtils.a("java.util.Iterator")) : a).isAssignableFrom(method.getReturnType()) && (iterator = (Iterator)method.invoke(object, null)) != null) {
                return iterator;
            }
        }
        catch (Exception exception) {}
        return IteratorUtils.singletonIterator(object);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

