/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.Statement;

public class PropertyNode
extends AnnotatedNode
implements Variable {
    private FieldNode field;
    private Statement getterBlock;
    private Statement setterBlock;
    private int modifiers;
    private boolean closureShare = false;

    public PropertyNode(String name, int modifiers, ClassNode type, ClassNode owner, Expression initialValueExpression, Statement getterBlock, Statement setterBlock) {
        this(new FieldNode(name, modifiers & 8, type, owner, initialValueExpression), modifiers, getterBlock, setterBlock);
    }

    public PropertyNode(FieldNode field, int modifiers, Statement getterBlock, Statement setterBlock) {
        this.field = field;
        this.modifiers = modifiers;
        this.getterBlock = getterBlock;
        this.setterBlock = setterBlock;
    }

    public Statement getGetterBlock() {
        return this.getterBlock;
    }

    public Expression getInitialExpression() {
        return this.field.getInitialExpression();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.field.getName();
    }

    public Statement getSetterBlock() {
        return this.setterBlock;
    }

    public ClassNode getType() {
        return this.field.getType();
    }

    public FieldNode getField() {
        return this.field;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isInStaticContext() {
        return this.field.isInStaticContext();
    }

    public boolean isDynamicTyped() {
        return this.field.isDynamicTyped();
    }

    public boolean isClosureSharedVariable() {
        return false;
    }

    public void setClosureSharedVariable(boolean inClosure) {
        this.closureShare = inClosure;
    }
}

