/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.time;

import java.util.Calendar;
import java.util.TimeZone;

public class DateUtils {
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final long MILLIS_PER_HOUR = 3600000L;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, new int[1]};

    private static void modify(Calendar val, int field, boolean round) {
        if (val.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        boolean roundUp = false;
        int i = 0;
        while (i < fields.length) {
            int j = 0;
            while (j < fields[i].length) {
                if (fields[i][j] == field) {
                    if (round && roundUp) {
                        if (field == 1001) {
                            if (val.get(5) == 1) {
                                val.add(5, 15);
                            } else {
                                val.add(5, -15);
                                val.add(2, 1);
                            }
                        } else {
                            val.add(fields[i][0], 1);
                        }
                    }
                    return;
                }
                ++j;
            }
            int offset = 0;
            boolean offsetSet = false;
            switch (field) {
                case 1001: {
                    if (fields[i][0] != 5) break;
                    offset = val.get(5) - 1;
                    if (offset >= 15) {
                        offset -= 15;
                    }
                    roundUp = offset > 7;
                    offsetSet = true;
                    break;
                }
                case 9: {
                    if (fields[i][0] != 11) break;
                    offset = val.get(11);
                    if (offset >= 12) {
                        offset -= 12;
                    }
                    roundUp = offset > 6;
                    offsetSet = true;
                    break;
                }
            }
            if (!offsetSet) {
                int min = val.getActualMinimum(fields[i][0]);
                int max = val.getActualMaximum(fields[i][0]);
                offset = val.get(fields[i][0]) - min;
                roundUp = offset > (max - min) / 2;
            }
            val.set(fields[i][0], val.get(fields[i][0]) - offset);
            ++i;
        }
        throw new IllegalArgumentException("The field " + field + " is not supported");
    }

    public static Calendar truncate(Calendar date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar truncated = (Calendar)date.clone();
        DateUtils.modify(truncated, field, false);
        return truncated;
    }
}

